/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider.kmip.attribute;

import com.unbound.common.Log;
import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.Attribute;

public class X509CertificateSubject
extends Attribute {
    public byte[] name = null;
    public byte[] alternativeName = null;

    public X509CertificateSubject() {
        super(KMIP.Tag.X509CertificateSubject);
    }

    public X509CertificateSubject(byte[] name, byte[] alternativeName) {
        this();
        this.name = name;
        this.alternativeName = alternativeName;
    }

    @Override
    public void convert(KMIPConverter converter) throws KMIPConvertException {
        int begin = converter.convertBegin(KMIP.tagAttributeValue(1));
        this.name = converter.convert(KMIP.Tag.SubjectDistinguishedName, this.name);
        this.alternativeName = converter.convertOptional(KMIP.Tag.SubjectAlternativeName, this.alternativeName);
        converter.convertEnd(begin);
    }

    @Override
    public void log() {
        Log.print("X509CertificateSubject").logLen("nameLen", this.name).logLen("alternativeNameLen", this.alternativeName).end();
    }
}

