/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider.kmip.object;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.object.Certificate;
import com.unbound.provider.kmip.object.OpaqueObject;
import com.unbound.provider.kmip.object.PGPKey;
import com.unbound.provider.kmip.object.PrivateKey;
import com.unbound.provider.kmip.object.PublicKey;
import com.unbound.provider.kmip.object.SecretData;
import com.unbound.provider.kmip.object.SymmetricKey;
import com.unbound.provider.kmip.object.Template;

public abstract class ManagedObject {
    public int tag;

    public ManagedObject(int _tag) {
        this.tag = _tag;
    }

    public abstract void convert(KMIPConverter var1) throws KMIPConvertException;

    public static ManagedObject create(int tag) throws KMIPConvertException {
        if (tag == KMIP.Tag.Certificate) {
            return new Certificate();
        }
        if (tag == KMIP.Tag.SymmetricKey) {
            return new SymmetricKey();
        }
        if (tag == KMIP.Tag.PrivateKey) {
            return new PrivateKey();
        }
        if (tag == KMIP.Tag.PublicKey) {
            return new PublicKey();
        }
        if (tag == KMIP.Tag.SecretData) {
            return new SecretData();
        }
        if (tag == KMIP.Tag.OpaqueObject) {
            return new OpaqueObject();
        }
        if (tag == KMIP.Tag.Template) {
            return new Template();
        }
        if (tag == KMIP.Tag.PGPKey) {
            return new PGPKey();
        }
        KMIPConverter.setError("Unexpected ManagedObject type " + tag);
        return null;
    }

    public abstract int getKMIPObjectType();

    public abstract void log();
}

