/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider.kmip.object;

import com.unbound.common.Log;
import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.object.KeyBlock;
import com.unbound.provider.kmip.object.ManagedObject;

public class PGPKey
extends ManagedObject {
    Integer version = null;
    public KeyBlock keyBlock = new KeyBlock();

    public PGPKey() {
        super(KMIP.Tag.PGPKey);
    }

    @Override
    public void convert(KMIPConverter converter) throws KMIPConvertException {
        int begin = converter.convertBegin(this.tag);
        this.keyBlock.convert(converter);
        this.version = converter.convert(KMIP.Tag.PGPKeyVersion, this.version);
        converter.convertEnd(begin);
    }

    @Override
    public int getKMIPObjectType() {
        return 9;
    }

    @Override
    public void log() {
        Log log = Log.func("PGPKey").log("version", this.version).end();
        if (this.keyBlock != null) {
            this.keyBlock.log();
        }
        log.leave();
    }
}

