/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider.kmip.request;

import com.unbound.common.Log;
import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.CryptoParams;
import com.unbound.provider.kmip.attribute.TemplateAttribute;
import com.unbound.provider.kmip.request.RequestItem;

public class DeriveRequest
extends RequestItem {
    public int objectType = 0;
    public String uid = null;
    public CryptoParams params = null;
    public byte[] data = null;
    public byte[] corr = null;
    public Boolean initInd = null;
    public Boolean finalInd = null;
    public TemplateAttribute template = new TemplateAttribute();
    public int derivationMethod = 0;
    public byte[] iv = null;
    public byte[] derivationData = null;
    public byte[] salt = null;
    public Integer iterationCount = null;

    public DeriveRequest() {
        super(5);
    }

    @Override
    public void convert(KMIPConverter converter) throws KMIPConvertException {
        this.objectType = converter.convert(KMIP.Tag.ObjectType, this.objectType);
        this.uid = converter.convert(KMIP.Tag.UniqueIdentifier, this.uid);
        this.derivationMethod = converter.convert(KMIP.Tag.DerivationMethod, this.derivationMethod);
        int begin = converter.convertBegin(KMIP.Tag.DerivationParameters);
        if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.CryptographicParameters) {
            this.params = new CryptoParams();
        }
        if (this.params != null) {
            this.params.convertValue(converter);
        }
        this.iv = converter.convertOptional(KMIP.Tag.IVCounterNonce, this.iv);
        this.derivationData = converter.convertOptional(KMIP.Tag.DerivationData, this.derivationData);
        this.salt = converter.convertOptional(KMIP.Tag.Salt, this.salt);
        this.iterationCount = converter.convertOptional(KMIP.Tag.IterationCount, this.iterationCount);
        converter.convertEnd(begin);
        this.template.convert(converter);
    }

    @Override
    public void log() {
        Log log = Log.func("DeriveRequest").log("uid", this.uid).log("derivationMethod", this.derivationMethod).log("objectType", this.objectType).logLen("ivLen", this.iv).logLen("derivationDataLen", this.derivationData).logLen("saltLen", this.salt).log("iterationCount", this.iterationCount).end();
        if (this.params != null) {
            this.params.log();
        }
        this.template.log();
        log.leave();
    }
}

