/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider.kmip.request;

import com.unbound.common.Log;
import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.request.RequestItem;
import java.util.ArrayList;

public class GetAttributesRequest
extends RequestItem {
    public String uid = null;
    public ArrayList<String> names = new ArrayList();
    public boolean getCorrespondingKey = false;

    public GetAttributesRequest() {
        super(11);
    }

    public GetAttributesRequest(String uid) {
        this();
        this.uid = uid;
    }

    public GetAttributesRequest(String uid, String attribute) {
        this(uid);
        this.names.add(attribute);
    }

    public GetAttributesRequest(String uid, ArrayList<String> names) {
        this(uid);
        this.names = names;
    }

    @Override
    public void convert(KMIPConverter converter) throws KMIPConvertException {
        this.uid = converter.convertOptional(KMIP.Tag.UniqueIdentifier, this.uid);
        converter.convertStrList(KMIP.Tag.AttributeName, this.names);
    }

    @Override
    public void log() {
        Log log = Log.func("GetAttributesRequest").log("uid", this.uid).end();
        for (String name : this.names) {
            Log.print("Attribute").log("name", name).end();
        }
        log.leave();
    }
}

