/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider.kmip.request;

import com.unbound.common.Log;
import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.CryptoParams;
import com.unbound.provider.kmip.request.RequestItem;

public class MACRequest
extends RequestItem {
    public String uid = null;
    public CryptoParams params = null;
    public byte[] data = null;
    public byte[] corr = null;
    public Boolean initInd = null;
    public Boolean finalInd = null;

    public MACRequest() {
        super(35);
    }

    @Override
    public void convert(KMIPConverter converter) throws KMIPConvertException {
        this.uid = converter.convertOptional(KMIP.Tag.UniqueIdentifier, this.uid);
        if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.CryptographicParameters) {
            this.params = new CryptoParams();
        }
        if (this.params != null) {
            this.params.convertValue(converter);
        }
        this.data = converter.convertOptional(KMIP.Tag.Data, this.data);
        this.corr = converter.convertOptional(KMIP.Tag.CorrelationValue, this.corr);
        this.initInd = converter.convertOptional(KMIP.Tag.InitIndicator, this.initInd);
        this.finalInd = converter.convertOptional(KMIP.Tag.FinalIndicator, this.finalInd);
    }

    @Override
    public void log() {
        Log log = Log.func("MACRequest").log("uid", this.uid).logLen("dataLen", this.data).log("initInd", this.initInd).log("finalInd", this.initInd).end();
        if (this.params != null) {
            this.params.log();
        }
        log.leave();
    }
}

