/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider.kmip.request;

import com.unbound.common.Log;
import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.TemplateAttribute;
import com.unbound.provider.kmip.request.RequestItem;

public class ReKeyPairRequest
extends RequestItem {
    public String uid = null;
    public Integer offset = null;
    public TemplateAttribute common = null;
    public TemplateAttribute prv = null;
    public TemplateAttribute pub = null;

    public ReKeyPairRequest() {
        super(29);
    }

    @Override
    public void convert(KMIPConverter converter) throws KMIPConvertException {
        this.uid = converter.convertOptional(KMIP.Tag.PrivateKeyUniqueIdentifier, this.uid);
        this.offset = converter.convertOptional(KMIP.Tag.Offset, this.offset);
        if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.CommonTemplateAttribute) {
            this.common = new TemplateAttribute();
        }
        if (this.common != null) {
            this.common.tag = KMIP.Tag.CommonTemplateAttribute;
            this.common.convert(converter);
        }
        if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.PrivateKeyTemplateAttribute) {
            this.prv = new TemplateAttribute();
        }
        if (this.prv != null) {
            this.prv.tag = KMIP.Tag.PrivateKeyTemplateAttribute;
            this.prv.convert(converter);
        }
        if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.PublicKeyTemplateAttribute) {
            this.pub = new TemplateAttribute();
        }
        if (this.pub != null) {
            this.pub.tag = KMIP.Tag.PublicKeyTemplateAttribute;
            this.pub.convert(converter);
        }
    }

    @Override
    public void log() {
        Log log = Log.func("ReKeyPairRequest").log("uid", this.uid).log("offset", this.offset).end();
        if (this.common != null) {
            this.common.log();
        }
        if (this.pub != null) {
            this.pub.log();
        }
        if (this.prv != null) {
            this.prv.log();
        }
        log.leave();
    }
}

