/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider.kmip.request;

import com.unbound.common.Log;
import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.TemplateAttribute;
import com.unbound.provider.kmip.object.ManagedObject;
import com.unbound.provider.kmip.request.RequestItem;

public class RegisterRequest
extends RequestItem {
    public int objectType = 0;
    public TemplateAttribute template = null;
    public ManagedObject object = null;

    public RegisterRequest() {
        super(3);
    }

    public RegisterRequest(ManagedObject object) {
        this();
        this.objectType = object.getKMIPObjectType();
        this.object = object;
    }

    @Override
    public void convert(KMIPConverter converter) throws KMIPConvertException {
        int tag;
        this.objectType = converter.convert(KMIP.Tag.ObjectType, this.objectType);
        if (!(converter.isWrite() || (tag = converter.getNextTag()) != KMIP.Tag.CommonTemplateAttribute && tag != KMIP.Tag.PrivateKeyTemplateAttribute && tag != KMIP.Tag.PublicKeyTemplateAttribute && tag != KMIP.Tag.TemplateAttribute)) {
            this.template = new TemplateAttribute();
        }
        if (this.template != null) {
            this.template.convert(converter);
        }
        if (!converter.isWrite()) {
            tag = converter.getNextTag();
            this.object = ManagedObject.create(tag);
        }
        this.object.convert(converter);
    }

    @Override
    public void log() {
        Log log = Log.func("RegisterRequest").log("objectType", this.objectType).end();
        if (this.template != null) {
            this.template.log();
        }
        if (this.object != null) {
            this.object.log();
        }
        log.leave();
    }
}

