/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider.kmip.request;

import com.unbound.common.HEX;
import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.MessageExt;
import com.unbound.provider.kmip.request.ActivateRequest;
import com.unbound.provider.kmip.request.AddAttributeRequest;
import com.unbound.provider.kmip.request.CancelRequest;
import com.unbound.provider.kmip.request.CheckRequest;
import com.unbound.provider.kmip.request.CreateKeyPairRequest;
import com.unbound.provider.kmip.request.CreateRequest;
import com.unbound.provider.kmip.request.DecryptRequest;
import com.unbound.provider.kmip.request.DeleteAttributeRequest;
import com.unbound.provider.kmip.request.DeriveRequest;
import com.unbound.provider.kmip.request.DestroyRequest;
import com.unbound.provider.kmip.request.DiscoverVersionsRequest;
import com.unbound.provider.kmip.request.EncryptRequest;
import com.unbound.provider.kmip.request.GetAttributeListRequest;
import com.unbound.provider.kmip.request.GetAttributesRequest;
import com.unbound.provider.kmip.request.GetRequest;
import com.unbound.provider.kmip.request.LocateRequest;
import com.unbound.provider.kmip.request.MACRequest;
import com.unbound.provider.kmip.request.MACVerifyRequest;
import com.unbound.provider.kmip.request.ModifyAttributeRequest;
import com.unbound.provider.kmip.request.PollRequest;
import com.unbound.provider.kmip.request.QueryRequest;
import com.unbound.provider.kmip.request.RNGRetrieveRequest;
import com.unbound.provider.kmip.request.RNGSeedRequest;
import com.unbound.provider.kmip.request.ReKeyPairRequest;
import com.unbound.provider.kmip.request.ReKeyRequest;
import com.unbound.provider.kmip.request.RegisterRequest;
import com.unbound.provider.kmip.request.RevokeRequest;
import com.unbound.provider.kmip.request.SignRequest;
import com.unbound.provider.kmip.request.SignatureVerifyRequest;
import com.unbound.provider.kmip.request.dy.DyDeriveRequest;
import com.unbound.provider.kmip.request.dy.DyLoginRequest;
import com.unbound.provider.kmip.request.dy.DyRegisterClientRequest;
import java.util.HashMap;
import java.util.Map;

public abstract class RequestItem {
    public int operation = 0;
    public byte[] requestUID = null;
    public MessageExt ext = null;
    private static final Map<Integer, Class<? extends RequestItem>> registry = new HashMap<Integer, Class<? extends RequestItem>>();

    public RequestItem(int _operation) {
        this.operation = _operation;
    }

    public static RequestItem convert(KMIPConverter converter, RequestItem item) throws KMIPConvertException {
        int begin = converter.convertBegin(KMIP.Tag.BatchItem);
        int operation = converter.isWrite() ? item.operation : 0;
        operation = converter.convert(KMIP.Tag.Operation, operation);
        if (!converter.isWrite()) {
            try {
                item = registry.get(operation).newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                item = null;
            }
            if (item == null) {
                KMIPConverter.setError("Unexpected request item for 0x" + HEX.toString(operation));
            }
        }
        item.requestUID = converter.convertOptional(KMIP.Tag.UniqueBatchItemID, item.requestUID);
        int payload_begin = converter.convertBegin(KMIP.Tag.RequestPayload);
        item.convert(converter);
        converter.convertEnd(payload_begin);
        if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.MessageExtension) {
            item.ext = new MessageExt();
        }
        if (item.ext != null) {
            item.ext.convert(converter);
        }
        converter.convertEnd(begin);
        return item;
    }

    public abstract void convert(KMIPConverter var1) throws KMIPConvertException;

    public String getName() {
        return this.getClass().getSimpleName().replace("Request", "");
    }

    public int getOperation() {
        return this.operation;
    }

    public abstract void log();

    static {
        registry.put(1, CreateRequest.class);
        registry.put(2, CreateKeyPairRequest.class);
        registry.put(3, RegisterRequest.class);
        registry.put(4, ReKeyRequest.class);
        registry.put(5, DeriveRequest.class);
        registry.put(7, CreateRequest.class);
        registry.put(8, LocateRequest.class);
        registry.put(9, CheckRequest.class);
        registry.put(10, GetRequest.class);
        registry.put(11, GetAttributesRequest.class);
        registry.put(12, GetAttributeListRequest.class);
        registry.put(13, AddAttributeRequest.class);
        registry.put(14, ModifyAttributeRequest.class);
        registry.put(15, DeleteAttributeRequest.class);
        registry.put(18, ActivateRequest.class);
        registry.put(19, RevokeRequest.class);
        registry.put(20, DestroyRequest.class);
        registry.put(24, QueryRequest.class);
        registry.put(25, CancelRequest.class);
        registry.put(26, PollRequest.class);
        registry.put(29, ReKeyPairRequest.class);
        registry.put(30, DiscoverVersionsRequest.class);
        registry.put(31, EncryptRequest.class);
        registry.put(32, DecryptRequest.class);
        registry.put(33, SignRequest.class);
        registry.put(34, SignatureVerifyRequest.class);
        registry.put(35, MACRequest.class);
        registry.put(36, MACVerifyRequest.class);
        registry.put(37, RNGRetrieveRequest.class);
        registry.put(38, RNGSeedRequest.class);
        registry.put(-2147483627, DyLoginRequest.class);
        registry.put(-2147483641, DyRegisterClientRequest.class);
        registry.put(-2147483639, DyDeriveRequest.class);
    }
}

