/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider.kmip.request;

import com.unbound.common.Log;
import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.request.RequestHeader;
import com.unbound.provider.kmip.request.RequestItem;
import java.util.ArrayList;

public class RequestMessage {
    public RequestHeader header = new RequestHeader();
    public ArrayList<RequestItem> batch = new ArrayList();

    public void convert(KMIPConverter converter) throws KMIPConvertException {
        if (this.header.batch_count == 0) {
            this.header.batch_count = this.batch.size();
        }
        int begin = converter.convertBegin(KMIP.Tag.RequestMessage);
        this.header.convert(converter);
        if (converter.isWrite()) {
            for (RequestItem item : this.batch) {
                RequestItem.convert(converter, item);
            }
        } else {
            for (int i = 0; i < this.header.batch_count; ++i) {
                RequestItem item = RequestItem.convert(converter, null);
                this.batch.add(item);
            }
        }
        converter.convertEnd(begin);
    }

    public void log() {
        Log log = Log.func("RequestMessage").end();
        for (int i = 0; i < this.header.batch_count; ++i) {
            this.batch.get(i).log();
        }
        log.leave();
    }
}

