/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider.kmip.request.dy;

import com.unbound.common.Log;
import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.CryptoParams;
import com.unbound.provider.kmip.request.RequestItem;

public class DyDeriveRequest
extends RequestItem {
    public String uid = null;
    public CryptoParams params = null;
    public Integer derivationMethod = null;
    public Integer secretSize = null;
    public byte[] data = null;

    public DyDeriveRequest() {
        super(-2147483639);
    }

    @Override
    public void convert(KMIPConverter converter) throws KMIPConvertException {
        this.uid = converter.convert(KMIP.Tag.UniqueIdentifier, this.uid);
        this.derivationMethod = converter.convertOptional(KMIP.Tag.DerivationMethod, this.derivationMethod);
        if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.CryptographicParameters) {
            this.params = new CryptoParams();
        }
        if (this.params != null) {
            this.params.convertValue(converter);
        }
        this.data = converter.convert(KMIP.Tag.Data, this.data);
        this.secretSize = converter.convertOptional(KMIP.Tag.DySecretSize, this.secretSize);
    }

    @Override
    public void log() {
        Log log = Log.func("DyDeriveRequest").log("uid", this.uid).logLen("dataLen", this.data).log("secretSize", this.secretSize).log("derivationMethod", this.derivationMethod).end();
        if (this.params != null) {
            this.params.log();
        }
        log.leave();
    }
}

