/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider.kmip.response;

import com.unbound.common.Log;
import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.TemplateAttribute;
import com.unbound.provider.kmip.response.ResponseItem;

public class CreateKeyPairResponse
extends ResponseItem {
    public String prvUID = "";
    public String pubUID = "";
    public TemplateAttribute common = null;
    public TemplateAttribute prv = null;
    public TemplateAttribute pub = null;

    public CreateKeyPairResponse() {
        super(2);
    }

    @Override
    public void convert(KMIPConverter converter) throws KMIPConvertException {
        this.prvUID = converter.convert(KMIP.Tag.PrivateKeyUniqueIdentifier, this.prvUID);
        this.pubUID = converter.convert(KMIP.Tag.PublicKeyUniqueIdentifier, this.pubUID);
        if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.CommonTemplateAttribute) {
            this.common = new TemplateAttribute();
        }
        if (this.common != null) {
            this.common.tag = KMIP.Tag.CommonTemplateAttribute;
            this.common.convert(converter);
        }
        if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.PrivateKeyTemplateAttribute) {
            this.prv = new TemplateAttribute();
        }
        if (this.prv != null) {
            this.prv.tag = KMIP.Tag.PrivateKeyTemplateAttribute;
            this.prv.convert(converter);
        }
        if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.PublicKeyTemplateAttribute) {
            this.pub = new TemplateAttribute();
        }
        if (this.pub != null) {
            this.pub.tag = KMIP.Tag.PublicKeyTemplateAttribute;
            this.pub.convert(converter);
        }
    }

    @Override
    public void log() {
        Log log = Log.func("CreateKeyPairResponse").log("prvUID", this.prvUID).log("pubUID", this.pubUID).end();
        if (this.common != null) {
            this.common.log();
        }
        if (this.pub != null) {
            this.pub.log();
        }
        if (this.prv != null) {
            this.prv.log();
        }
        log.leave();
    }
}

