/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider.kmip.response;

import com.unbound.common.Log;
import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.response.ResponseItem;

public class EncryptResponse
extends ResponseItem {
    public String uid = null;
    public byte[] data = null;
    public byte[] corr = null;
    public byte[] iv = null;
    public byte[] authEncTag = null;

    public EncryptResponse() {
        super(31);
    }

    @Override
    public void convert(KMIPConverter converter) throws KMIPConvertException {
        this.uid = converter.convert(KMIP.Tag.UniqueIdentifier, this.uid);
        this.data = converter.convertOptional(KMIP.Tag.Data, this.data);
        this.iv = converter.convertOptional(KMIP.Tag.IVCounterNonce, this.iv);
        this.corr = converter.convertOptional(KMIP.Tag.CorrelationValue, this.corr);
        this.authEncTag = converter.convertOptional(KMIP.Tag.AuthenticatedEncryptionTag, this.authEncTag);
    }

    @Override
    public void log() {
        Log.print("EncryptResponse").log("uid", this.uid).logLen("dataLen", this.data).logLen("ivLen", this.iv).logLen("authEncTagLen", this.authEncTag).end();
    }
}

