/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider.kmip.response;

import com.unbound.common.HEX;
import com.unbound.common.Log;
import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.response.ActivateResponse;
import com.unbound.provider.kmip.response.AddAttributeResponse;
import com.unbound.provider.kmip.response.CancelResponse;
import com.unbound.provider.kmip.response.CheckResponse;
import com.unbound.provider.kmip.response.CreateKeyPairResponse;
import com.unbound.provider.kmip.response.CreateResponse;
import com.unbound.provider.kmip.response.DecryptResponse;
import com.unbound.provider.kmip.response.DeleteAttributeResponse;
import com.unbound.provider.kmip.response.DeriveResponse;
import com.unbound.provider.kmip.response.DestroyResponse;
import com.unbound.provider.kmip.response.DiscoverVersionsResponse;
import com.unbound.provider.kmip.response.EncryptResponse;
import com.unbound.provider.kmip.response.FailureResponse;
import com.unbound.provider.kmip.response.GetAttributeListResponse;
import com.unbound.provider.kmip.response.GetAttributesResponse;
import com.unbound.provider.kmip.response.GetResponse;
import com.unbound.provider.kmip.response.LocateResponse;
import com.unbound.provider.kmip.response.MACResponse;
import com.unbound.provider.kmip.response.MACVerifyResponse;
import com.unbound.provider.kmip.response.ModifyAttributeResponse;
import com.unbound.provider.kmip.response.PollResponse;
import com.unbound.provider.kmip.response.QueryResponse;
import com.unbound.provider.kmip.response.RNGRetrieveResponse;
import com.unbound.provider.kmip.response.RNGSeedResponse;
import com.unbound.provider.kmip.response.ReKeyPairResponse;
import com.unbound.provider.kmip.response.ReKeyResponse;
import com.unbound.provider.kmip.response.RegisterResponse;
import com.unbound.provider.kmip.response.RevokeResponse;
import com.unbound.provider.kmip.response.SignResponse;
import com.unbound.provider.kmip.response.SignatureVerifyResponse;
import com.unbound.provider.kmip.response.dy.DyDeriveResponse;
import com.unbound.provider.kmip.response.dy.DyLoginResponse;
import com.unbound.provider.kmip.response.dy.DyRegisterClientResponse;
import java.util.HashMap;
import java.util.Map;

public abstract class ResponseItem {
    public int operation = 0;
    public byte[] responseUID = null;
    public int resultStatus = 0;
    public Integer reason = null;
    public String resultMsg = null;
    public byte[] asynch = null;
    private static final Map<Integer, Class<? extends ResponseItem>> registry = new HashMap<Integer, Class<? extends ResponseItem>>();
    public String serializedResult = "";

    public ResponseItem(int _operation) {
        this.operation = _operation;
    }

    public static ResponseItem convert(KMIPConverter converter, ResponseItem item) throws KMIPConvertException {
        int begin = converter.convertBegin(KMIP.Tag.BatchItem);
        if (converter.isWrite()) {
            if (item.operation != 0) {
                converter.convert(KMIP.Tag.Operation, item.operation);
            }
        } else {
            Integer operation = converter.convertOptional(KMIP.Tag.Operation, 0);
            if (operation == null) {
                operation = 0;
            }
            try {
                item = registry.get(operation).newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                item = null;
            }
            if (item == null) {
                KMIPConverter.setError("Unexpected response item for 0x" + HEX.toString(operation));
            }
        }
        item.responseUID = converter.convertOptional(KMIP.Tag.UniqueBatchItemID, item.responseUID);
        item.resultStatus = converter.convert(KMIP.Tag.ResultStatus, item.resultStatus);
        item.reason = converter.convertOptional(KMIP.Tag.ResultReason, item.reason);
        item.resultMsg = converter.convertOptional(KMIP.Tag.ResultMessage, item.resultMsg);
        item.asynch = converter.convertOptional(KMIP.Tag.AsynchronousCorrelationValue, item.asynch);
        if (item.resultStatus == 0) {
            int payload_begin = converter.convertBegin(KMIP.Tag.ResponsePayload);
            item.convert(converter);
            converter.convertEnd(payload_begin);
        }
        converter.convertEnd(begin);
        return item;
    }

    public int getOperation() {
        return this.operation;
    }

    public void logStatus() {
        Log log = Log.func("FailureResponseItem").log("reason", this.reason).log("resultStatus", this.resultStatus).end();
        log.failed(new Exception(this.resultMsg));
        log.leave();
    }

    public abstract void convert(KMIPConverter var1) throws KMIPConvertException;

    public abstract void log();

    static {
        registry.put(0, FailureResponse.class);
        registry.put(1, CreateResponse.class);
        registry.put(2, CreateKeyPairResponse.class);
        registry.put(3, RegisterResponse.class);
        registry.put(4, ReKeyResponse.class);
        registry.put(5, DeriveResponse.class);
        registry.put(7, CreateResponse.class);
        registry.put(8, LocateResponse.class);
        registry.put(9, CheckResponse.class);
        registry.put(10, GetResponse.class);
        registry.put(11, GetAttributesResponse.class);
        registry.put(12, GetAttributeListResponse.class);
        registry.put(13, AddAttributeResponse.class);
        registry.put(14, ModifyAttributeResponse.class);
        registry.put(15, DeleteAttributeResponse.class);
        registry.put(18, ActivateResponse.class);
        registry.put(19, RevokeResponse.class);
        registry.put(20, DestroyResponse.class);
        registry.put(24, QueryResponse.class);
        registry.put(25, CancelResponse.class);
        registry.put(26, PollResponse.class);
        registry.put(29, ReKeyPairResponse.class);
        registry.put(30, DiscoverVersionsResponse.class);
        registry.put(31, EncryptResponse.class);
        registry.put(32, DecryptResponse.class);
        registry.put(33, SignResponse.class);
        registry.put(34, SignatureVerifyResponse.class);
        registry.put(35, MACResponse.class);
        registry.put(36, MACVerifyResponse.class);
        registry.put(37, RNGRetrieveResponse.class);
        registry.put(38, RNGSeedResponse.class);
        registry.put(-2147483627, DyLoginResponse.class);
        registry.put(-2147483641, DyRegisterClientResponse.class);
        registry.put(-2147483639, DyDeriveResponse.class);
    }
}

