/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa;

import it.unive.lisa.AnalysisSetupException;
import it.unive.lisa.LiSA;
import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.SimpleAbstractState;
import it.unive.lisa.analysis.dataflow.DataflowElement;
import it.unive.lisa.analysis.dataflow.DefiniteForwardDataflowDomain;
import it.unive.lisa.analysis.dataflow.PossibleForwardDataflowDomain;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.heap.MonolithicHeap;
import it.unive.lisa.analysis.nonrelational.heap.HeapEnvironment;
import it.unive.lisa.analysis.nonrelational.heap.NonRelationalHeapDomain;
import it.unive.lisa.analysis.nonrelational.inference.InferenceSystem;
import it.unive.lisa.analysis.nonrelational.inference.InferredValue;
import it.unive.lisa.analysis.nonrelational.value.NonRelationalValueDomain;
import it.unive.lisa.analysis.nonrelational.value.ValueEnvironment;
import it.unive.lisa.analysis.numeric.Interval;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.interprocedural.ContextBasedAnalysis;
import it.unive.lisa.interprocedural.ContextSensitivityToken;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.interprocedural.ModularWorstCaseAnalysis;
import it.unive.lisa.interprocedural.RecursionFreeToken;
import it.unive.lisa.interprocedural.callgraph.CallGraph;
import it.unive.lisa.interprocedural.callgraph.RTACallGraph;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.reflections.Reflections;
import org.reflections.scanners.SubTypesScanner;

public final class LiSAFactory {
    static final Map<Class<?>, Class<?>> DEFAULT_IMPLEMENTATIONS = new HashMap();
    static final Map<Class<?>, Class<?>[]> DEFAULT_PARAMETERS = new HashMap();

    private LiSAFactory() {
    }

    private static <T> T construct(Class<T> component, Class<?>[] argTypes, Object[] params) throws AnalysisSetupException {
        if (ContextSensitivityToken.class.isAssignableFrom(component)) {
            try {
                Method method = component.getMethod("getSingleton", new Class[0]);
                if (!Modifier.isStatic(method.getModifiers())) {
                    throw new AnalysisSetupException("Unable to instantiate " + component.getSimpleName() + ": getSingleton() is not static");
                }
                return (T)method.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new AnalysisSetupException("Unable to instantiate " + component.getSimpleName(), (Throwable)e);
            }
        }
        try {
            Constructor<T> constructor = component.getConstructor(argTypes);
            return constructor.newInstance(params);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new AnalysisSetupException("Unable to instantiate " + component.getSimpleName(), (Throwable)e);
        }
    }

    private static Class<?>[] findConstructorSignature(Class<?> component, Object[] params) throws AnalysisSetupException {
        IdentityHashMap candidates = new IdentityHashMap();
        block0: for (Constructor<?> constructor : component.getConstructors()) {
            Class<?>[] types = constructor.getParameterTypes();
            if (params.length != types.length) continue;
            ArrayList<Integer> toWrap = new ArrayList<Integer>();
            for (int i = 0; i < types.length; ++i) {
                if (LiSAFactory.needsWrapping(params[i].getClass(), types[i])) {
                    toWrap.add(i);
                    continue;
                }
                if (!types[i].isAssignableFrom(params[i].getClass())) continue block0;
            }
            candidates.put(constructor, toWrap);
        }
        if (candidates.isEmpty()) {
            throw new AnalysisSetupException("No suitable constructor of " + component.getSimpleName() + " found for argument types " + Arrays.toString(Arrays.stream(params).map(Object::getClass).toArray(Class[]::new)));
        }
        if (candidates.size() > 1) {
            throw new AnalysisSetupException("Constructor call of " + component.getSimpleName() + " is ambiguous for argument types " + Arrays.toString(Arrays.stream(params).map(Object::getClass).toArray(Class[]::new)));
        }
        Iterator iterator = ((List)candidates.values().iterator().next()).iterator();
        while (iterator.hasNext()) {
            int p = (Integer)iterator.next();
            params[p] = LiSAFactory.wrapParam(params[p]);
        }
        return ((Constructor)candidates.keySet().iterator().next()).getParameterTypes();
    }

    private static boolean needsWrapping(Class<?> actual, Class<?> desired) {
        if (NonRelationalHeapDomain.class.isAssignableFrom(actual) && desired.isAssignableFrom(HeapDomain.class)) {
            return true;
        }
        if (NonRelationalValueDomain.class.isAssignableFrom(actual) && desired.isAssignableFrom(ValueDomain.class)) {
            return true;
        }
        if (InferredValue.class.isAssignableFrom(actual) && desired.isAssignableFrom(ValueDomain.class)) {
            return true;
        }
        return DataflowElement.class.isAssignableFrom(actual) && desired.isAssignableFrom(ValueDomain.class);
    }

    private static Object wrapParam(Object param) {
        if (NonRelationalHeapDomain.class.isAssignableFrom(param.getClass())) {
            return new HeapEnvironment((NonRelationalHeapDomain)param);
        }
        if (NonRelationalValueDomain.class.isAssignableFrom(param.getClass())) {
            return new ValueEnvironment((NonRelationalValueDomain)param);
        }
        if (InferredValue.class.isAssignableFrom(param.getClass())) {
            return new InferenceSystem((InferredValue)param);
        }
        if (DataflowElement.class.isAssignableFrom(param.getClass())) {
            Class<?> elem = param.getClass();
            if (elem.getGenericInterfaces().length == 0) {
                return param;
            }
            for (Type gi : elem.getGenericInterfaces()) {
                if (!(gi instanceof ParameterizedType) || ((ParameterizedType)gi).getRawType() != DataflowElement.class) continue;
                Type domain = ((ParameterizedType)gi).getActualTypeArguments()[0];
                if (((ParameterizedType)domain).getRawType() == PossibleForwardDataflowDomain.class) {
                    return new PossibleForwardDataflowDomain((DataflowElement)param);
                }
                if (((ParameterizedType)domain).getRawType() == DefiniteForwardDataflowDomain.class) {
                    return new DefiniteForwardDataflowDomain((DataflowElement)param);
                }
                return param;
            }
        }
        return param;
    }

    public static <T> T getInstance(Class<T> component, Object ... params) throws AnalysisSetupException {
        try {
            Class<?>[] defaultParams;
            if (params != null && params.length != 0) {
                return LiSAFactory.construct(component, LiSAFactory.findConstructorSignature(component, params), params);
            }
            if (!DEFAULT_PARAMETERS.containsKey(component) || (defaultParams = DEFAULT_PARAMETERS.get(component)) == null || defaultParams.length == 0) {
                return LiSAFactory.construct(component, ArrayUtils.EMPTY_CLASS_ARRAY, ArrayUtils.EMPTY_OBJECT_ARRAY);
            }
            Object[] defaults = new Object[defaultParams.length];
            for (int i = 0; i < defaults.length; ++i) {
                defaults[i] = LiSAFactory.getInstance(defaultParams[i], new Object[0]);
            }
            return LiSAFactory.construct(component, LiSAFactory.findConstructorSignature(component, defaults), defaults);
        }
        catch (NullPointerException e) {
            throw new AnalysisSetupException("Unable to instantiate default " + component.getSimpleName(), (Throwable)e);
        }
    }

    public static void registerDefaultFor(Class<?> component, Class<?> defaultImplementation) {
        DEFAULT_IMPLEMENTATIONS.put(component, defaultImplementation);
    }

    public static void registerDefaultParametersFor(Class<?> component, Class<?> ... defaultParameters) {
        DEFAULT_PARAMETERS.put(component, defaultParameters);
    }

    public static <T> T getDefaultFor(Class<T> component, Object ... params) throws AnalysisSetupException {
        try {
            Class<?> def = DEFAULT_IMPLEMENTATIONS.get(component);
            if (def == null) {
                throw new AnalysisSetupException("No registered default for " + component);
            }
            Class[] defParams = DEFAULT_PARAMETERS.getOrDefault(def, ArrayUtils.EMPTY_CLASS_ARRAY);
            if (params.length == 0 && defParams.length > 0) {
                params = new Object[defParams.length];
                for (int i = 0; i < params.length; ++i) {
                    params[i] = LiSAFactory.getInstance(defParams[i], new Object[0]);
                }
            }
            if (LiSAFactory.needsWrapping(def, component)) {
                return (T)LiSAFactory.wrapParam(LiSAFactory.getInstance(def, params));
            }
            return (T)LiSAFactory.getInstance(def, params);
        }
        catch (NullPointerException e) {
            throw new AnalysisSetupException("Unable to instantiate default " + component.getSimpleName(), (Throwable)e);
        }
    }

    public static Collection<ConfigurableComponent<?>> configurableComponents() {
        ArrayList in = new ArrayList();
        in.add(new ConfigurableComponent<InterproceduralAnalysis>(InterproceduralAnalysis.class));
        in.add(new ConfigurableComponent<CallGraph>(CallGraph.class));
        in.add(new ConfigurableComponent<AbstractState>(AbstractState.class));
        in.add(new ConfigurableComponent<HeapDomain>(HeapDomain.class));
        in.add(new ConfigurableComponent<ValueDomain>(ValueDomain.class));
        in.add(new ConfigurableComponent<NonRelationalHeapDomain>(NonRelationalHeapDomain.class));
        in.add(new ConfigurableComponent<NonRelationalValueDomain>(NonRelationalValueDomain.class));
        in.add(new ConfigurableComponent<InferredValue>(InferredValue.class));
        in.add(new ConfigurableComponent<DataflowElement>(DataflowElement.class));
        return in;
    }

    static {
        DEFAULT_IMPLEMENTATIONS.put(InterproceduralAnalysis.class, ModularWorstCaseAnalysis.class);
        DEFAULT_IMPLEMENTATIONS.put(CallGraph.class, RTACallGraph.class);
        DEFAULT_IMPLEMENTATIONS.put(HeapDomain.class, MonolithicHeap.class);
        DEFAULT_IMPLEMENTATIONS.put(ValueDomain.class, Interval.class);
        DEFAULT_IMPLEMENTATIONS.put(AbstractState.class, SimpleAbstractState.class);
        DEFAULT_PARAMETERS.put(SimpleAbstractState.class, new Class[]{MonolithicHeap.class, Interval.class});
        DEFAULT_PARAMETERS.put(ContextBasedAnalysis.class, new Class[]{RecursionFreeToken.class});
    }

    public static final class ConfigurableComponent<T> {
        private static final Reflections scanner = new Reflections(new Object[]{LiSA.class, new SubTypesScanner()});
        private final Class<T> component;
        private final Class<? extends T> defaultInstance;
        private final Class<?>[] defaultParameters;
        private final Collection<Class<? extends T>> alternatives;

        private ConfigurableComponent(Class<T> component) {
            this.component = component;
            if (DEFAULT_IMPLEMENTATIONS.containsKey(component)) {
                this.defaultInstance = DEFAULT_IMPLEMENTATIONS.get(component);
                this.defaultParameters = DEFAULT_PARAMETERS.containsKey(this.defaultInstance) ? DEFAULT_PARAMETERS.get(this.defaultInstance) : null;
            } else {
                this.defaultInstance = null;
                this.defaultParameters = null;
            }
            this.alternatives = scanner.getSubTypesOf(component).stream().map(c -> Pair.of((Object)c, (Object)c.getModifiers())).filter(p -> !Modifier.isAbstract((Integer)p.getRight()) && !Modifier.isInterface((Integer)p.getRight())).map(p -> (Class)p.getLeft()).collect(Collectors.toList());
        }

        public Class<T> getComponent() {
            return this.component;
        }

        public Class<? extends T> getDefaultInstance() {
            return this.defaultInstance;
        }

        public Class<?>[] getDefaultParameters() {
            return this.defaultParameters;
        }

        public Collection<Class<? extends T>> getAlternatives() {
            return this.alternatives;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.alternatives == null ? 0 : this.alternatives.hashCode());
            result = 31 * result + (this.component == null ? 0 : this.component.hashCode());
            result = 31 * result + (this.defaultInstance == null ? 0 : this.defaultInstance.hashCode());
            result = 31 * result + (this.defaultParameters == null ? 0 : Arrays.hashCode(this.defaultParameters));
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConfigurableComponent other = (ConfigurableComponent)obj;
            if (this.alternatives == null ? other.alternatives != null : !this.alternatives.equals(other.alternatives)) {
                return false;
            }
            if (this.component == null ? other.component != null : !this.component.equals(other.component)) {
                return false;
            }
            if (this.defaultInstance == null ? other.defaultInstance != null : !this.defaultInstance.equals(other.defaultInstance)) {
                return false;
            }
            return !(this.defaultParameters == null ? other.defaultParameters != null : !Arrays.equals(this.defaultParameters, other.defaultParameters));
        }

        public String toString() {
            Object result = this.component.getName();
            if (this.defaultInstance != null) {
                result = (String)result + " (defaults to: '" + this.defaultInstance.getName() + "'";
                if (this.defaultParameters != null && this.defaultParameters.length != 0) {
                    Object[] paramNames = (String[])Arrays.stream(this.defaultParameters).map(c -> c.getName()).toArray(String[]::new);
                    result = (String)result + " with parameters [" + StringUtils.join((Object[])paramNames, (String)", ") + "]";
                }
                result = (String)result + ")";
            }
            String[] alternatives = (String[])this.alternatives.stream().map(c -> c.getName()).toArray(String[]::new);
            result = (String)result + " possible implementations: " + alternatives;
            return result;
        }
    }
}

