/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa;

import it.unive.lisa.AnalysisExecutionException;
import it.unive.lisa.AnalysisSetupException;
import it.unive.lisa.LiSAConfiguration;
import it.unive.lisa.LiSAFactory;
import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.CFGWithAnalysisResults;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.caches.Caches;
import it.unive.lisa.checks.ChecksExecutor;
import it.unive.lisa.checks.semantic.CheckToolWithAnalysisResults;
import it.unive.lisa.checks.semantic.SemanticCheck;
import it.unive.lisa.checks.syntactic.CheckTool;
import it.unive.lisa.checks.warnings.Warning;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.interprocedural.InterproceduralAnalysisException;
import it.unive.lisa.interprocedural.OpenCallPolicy;
import it.unive.lisa.interprocedural.callgraph.CallGraph;
import it.unive.lisa.interprocedural.callgraph.CallGraphConstructionException;
import it.unive.lisa.logging.IterationLogger;
import it.unive.lisa.logging.TimerLogger;
import it.unive.lisa.program.Program;
import it.unive.lisa.program.ProgramValidationException;
import it.unive.lisa.program.SyntheticLocation;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.edge.Edge;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Skip;
import it.unive.lisa.type.Type;
import it.unive.lisa.util.collections.externalSet.ExternalSet;
import it.unive.lisa.util.datastructures.graph.GraphVisitor;
import it.unive.lisa.util.datastructures.graph.algorithms.FixpointException;
import it.unive.lisa.util.file.FileManager;
import java.io.IOException;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LiSARunner<A extends AbstractState<A, H, V>, H extends HeapDomain<H>, V extends ValueDomain<V>, T extends AbstractState<T, HT, VT>, HT extends HeapDomain<HT>, VT extends ValueDomain<VT>> {
    private static final String FIXPOINT_EXCEPTION_MESSAGE = "Exception during fixpoint computation";
    private static final Logger LOG = LogManager.getLogger(LiSARunner.class);
    private final LiSAConfiguration conf;
    private final InterproceduralAnalysis<A, H, V> interproc;
    private final CallGraph callGraph;
    private final A state;
    private final T typeState;
    private final Function<T, ExternalSet<Type>> typeExtractor;

    LiSARunner(LiSAConfiguration conf, InterproceduralAnalysis<A, H, V> interproc, CallGraph callGraph, A state, T typeState, Function<T, ExternalSet<Type>> typeExtractor) {
        this.conf = conf;
        this.interproc = interproc;
        this.callGraph = callGraph;
        this.state = state;
        this.typeState = typeState;
        this.typeExtractor = typeExtractor;
    }

    Collection<Warning> run(Program program, FileManager fileManager) {
        LiSARunner.finalizeProgram(program);
        Collection allCFGs = program.getAllCFGs();
        if (this.conf.isDumpCFGs()) {
            for (CFG cfg : IterationLogger.iterate((Logger)LOG, (Collection)allCFGs, (String)"Dumping input CFGs", (String)"cfgs")) {
                LiSARunner.dumpCFG(fileManager, "", cfg, st -> "");
            }
        }
        CheckTool tool = new CheckTool();
        if (!this.conf.getSyntacticChecks().isEmpty()) {
            ChecksExecutor.executeAll((Object)tool, (Program)program, this.conf.getSyntacticChecks());
        } else {
            LOG.warn("Skipping syntactic checks execution since none have been provided");
        }
        try {
            this.callGraph.init(program);
        }
        catch (CallGraphConstructionException e) {
            LOG.fatal("Exception while building the call graph for the input program", (Throwable)e);
            throw new AnalysisExecutionException("Exception while building the call graph for the input program", (Throwable)e);
        }
        try {
            this.interproc.init(program, this.callGraph, this.conf.getOpenCallPolicy());
        }
        catch (InterproceduralAnalysisException e) {
            LOG.fatal("Exception while building the interprocedural analysis for the input program", (Throwable)e);
            throw new AnalysisExecutionException("Exception while building the interprocedural analysis for the input program", (Throwable)e);
        }
        if (this.conf.isInferTypes()) {
            this.inferTypes(fileManager, program, allCFGs, this.conf.getOpenCallPolicy());
        } else {
            LOG.warn("Type inference disabled: dynamic type information will not be available for following analysis");
        }
        if (this.state != null) {
            this.analyze(allCFGs, fileManager);
            IdentityHashMap<CFG, Collection> results = new IdentityHashMap<CFG, Collection>(allCFGs.size());
            for (CFG cfg : allCFGs) {
                results.put(cfg, this.interproc.getAnalysisResultsOf(cfg));
            }
            Collection<SemanticCheck<?, ?, ?>> semanticChecks = this.conf.getSemanticChecks();
            if (!semanticChecks.isEmpty()) {
                CheckToolWithAnalysisResults tool2 = new CheckToolWithAnalysisResults(tool, results, this.callGraph);
                tool = tool2;
                ChecksExecutor.executeAll((Object)tool2, (Program)program, semanticChecks);
            } else {
                LOG.warn("Skipping semantic checks execution since none have been provided");
            }
        } else {
            LOG.warn("Skipping analysis execution since no abstract sate has been provided");
        }
        return tool.getWarnings();
    }

    private void analyze(Collection<CFG> allCFGs, FileManager fileManager) {
        AbstractState state = (AbstractState)this.state.top();
        TimerLogger.execAction((Logger)LOG, (String)"Computing fixpoint over the whole program", () -> {
            try {
                this.interproc.fixpoint(new AnalysisState(state, (SymbolicExpression)new Skip((CodeLocation)SyntheticLocation.INSTANCE)), this.conf.getFixpointWorkingSet(), this.conf.getWideningThreshold());
            }
            catch (FixpointException e) {
                LOG.fatal(FIXPOINT_EXCEPTION_MESSAGE, (Throwable)e);
                throw new AnalysisExecutionException(FIXPOINT_EXCEPTION_MESSAGE, (Throwable)e);
            }
        });
        if (this.conf.isDumpAnalysis()) {
            for (CFG cfg : IterationLogger.iterate((Logger)LOG, allCFGs, (String)"Dumping analysis results", (String)"cfgs")) {
                for (CFGWithAnalysisResults result : this.interproc.getAnalysisResultsOf(cfg)) {
                    LiSARunner.dumpCFG(fileManager, "analysis___" + (String)(result.getId() == null ? "" : result.getId().hashCode() + "_"), (CFG)result, st -> result.getAnalysisStateAfter(st).toString());
                }
            }
        }
    }

    private void inferTypes(FileManager fileManager, Program program, Collection<CFG> allCFGs, OpenCallPolicy policy) {
        InterproceduralAnalysis typesInterproc;
        AbstractState typesState = (AbstractState)this.typeState.top();
        try {
            CallGraph typesCg = (CallGraph)LiSAFactory.getInstance(this.callGraph.getClass(), new Object[0]);
            typesInterproc = (InterproceduralAnalysis)LiSAFactory.getInstance(this.interproc.getClass(), new Object[0]);
            typesCg.init(program);
            typesInterproc.init(program, typesCg, policy);
        }
        catch (AnalysisSetupException | InterproceduralAnalysisException | CallGraphConstructionException e) {
            throw new AnalysisExecutionException("Unable to initialize type inference", e);
        }
        TimerLogger.execAction((Logger)LOG, (String)"Computing type information", () -> {
            try {
                typesInterproc.fixpoint(new AnalysisState(typesState, (SymbolicExpression)new Skip((CodeLocation)SyntheticLocation.INSTANCE)), this.conf.getFixpointWorkingSet(), this.conf.getWideningThreshold());
            }
            catch (FixpointException e) {
                LOG.fatal(FIXPOINT_EXCEPTION_MESSAGE, (Throwable)e);
                throw new AnalysisExecutionException(FIXPOINT_EXCEPTION_MESSAGE, (Throwable)e);
            }
        });
        String message = this.conf.isDumpTypeInference() ? "Dumping type analysis and propagating it to cfgs" : "Propagating type information to cfgs";
        for (CFG cfg : IterationLogger.iterate((Logger)LOG, allCFGs, (String)message, (String)"cfgs")) {
            Collection results = typesInterproc.getAnalysisResultsOf(cfg);
            if (results.isEmpty()) {
                LOG.warn("No type information computed for '{}': it is unreachable", (Object)cfg);
                continue;
            }
            CFGWithAnalysisResults result = null;
            try {
                for (CFGWithAnalysisResults res : results) {
                    if (result == null) {
                        result = res;
                        continue;
                    }
                    result = result.join(res);
                }
            }
            catch (SemanticException e) {
                throw new AnalysisExecutionException("Unable to compute type information for " + cfg, (Throwable)e);
            }
            cfg.accept((GraphVisitor)new TypesPropagator(), (Object)result);
            CFGWithAnalysisResults r = result;
            if (!this.conf.isDumpTypeInference()) continue;
            LiSARunner.dumpCFG(fileManager, "typing___", (CFG)r, st -> r.getAnalysisStateAfter(st).toString());
        }
    }

    private static void finalizeProgram(Program program) {
        Caches.types().clear();
        ExternalSet types = Caches.types().mkEmptySet();
        program.getRegisteredTypes().forEach(arg_0 -> types.add(arg_0));
        types = null;
        TimerLogger.execAction((Logger)LOG, (String)"Finalizing input program", () -> {
            try {
                program.validateAndFinalize();
            }
            catch (ProgramValidationException e) {
                throw new AnalysisExecutionException("Unable to finalize target program", (Throwable)e);
            }
        });
    }

    private static void dumpCFG(FileManager fileManager, String filePrefix, CFG cfg, Function<Statement, String> labelGenerator) {
        try {
            fileManager.mkDotFile(filePrefix + cfg.getDescriptor().getFullSignatureWithParNames(), writer -> cfg.dump(writer, labelGenerator::apply));
        }
        catch (IOException e) {
            LOG.error("Exception while dumping the analysis results on {}", (Object)cfg.getDescriptor().getFullSignature());
            LOG.error((Object)e);
        }
    }

    private class TypesPropagator
    implements GraphVisitor<CFG, Statement, Edge, CFGWithAnalysisResults<T, HT, VT>> {
        private TypesPropagator() {
        }

        public boolean visit(CFGWithAnalysisResults<T, HT, VT> tool, CFG graph) {
            return true;
        }

        public boolean visit(CFGWithAnalysisResults<T, HT, VT> tool, CFG graph, Edge edge) {
            return true;
        }

        public boolean visit(CFGWithAnalysisResults<T, HT, VT> tool, CFG graph, Statement node) {
            if (tool != null && node instanceof Expression) {
                ((Expression)node).setRuntimeTypes(LiSARunner.this.typeExtractor.apply(tool.getAnalysisStateAfter(node).getState()));
            }
            return true;
        }
    }
}

