/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.dataflow;

import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.dataflow.DataflowElement;
import it.unive.lisa.analysis.dataflow.DefiniteForwardDataflowDomain;
import it.unive.lisa.analysis.representation.DomainRepresentation;
import it.unive.lisa.analysis.representation.PairRepresentation;
import it.unive.lisa.analysis.representation.StringRepresentation;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.BinaryExpression;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.OutOfScopeIdentifier;
import it.unive.lisa.symbolic.value.UnaryExpression;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.symbolic.value.operator.AdditionOperator;
import it.unive.lisa.symbolic.value.operator.DivisionOperator;
import it.unive.lisa.symbolic.value.operator.Module;
import it.unive.lisa.symbolic.value.operator.Multiplication;
import it.unive.lisa.symbolic.value.operator.SubtractionOperator;
import it.unive.lisa.symbolic.value.operator.unary.NumericNegation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class ConstantPropagation
implements DataflowElement<DefiniteForwardDataflowDomain<ConstantPropagation>, ConstantPropagation> {
    private final Identifier id;
    private final Integer constant;

    public ConstantPropagation() {
        this(null, null);
    }

    private ConstantPropagation(Identifier id, Integer v) {
        this.id = id;
        this.constant = v;
    }

    public String toString() {
        return this.representation().toString();
    }

    public Collection<Identifier> getInvolvedIdentifiers() {
        return Collections.singleton(this.id);
    }

    private static Integer eval(SymbolicExpression e, DefiniteForwardDataflowDomain<ConstantPropagation> domain) {
        if (e instanceof Constant) {
            Constant c = (Constant)e;
            return c.getValue() instanceof Integer ? (Integer)c.getValue() : null;
        }
        if (e instanceof Identifier) {
            for (ConstantPropagation cp : domain.getDataflowElements()) {
                if (!cp.id.equals((Object)e)) continue;
                return cp.constant;
            }
            return null;
        }
        if (e instanceof UnaryExpression) {
            UnaryExpression unary = (UnaryExpression)e;
            Integer i = ConstantPropagation.eval(unary.getExpression(), domain);
            if (i == null) {
                return i;
            }
            if (unary.getOperator() == NumericNegation.INSTANCE) {
                return -i.intValue();
            }
        }
        if (e instanceof BinaryExpression) {
            BinaryExpression binary = (BinaryExpression)e;
            Integer right = ConstantPropagation.eval(binary.getRight(), domain);
            Integer left = ConstantPropagation.eval(binary.getLeft(), domain);
            if (right == null || left == null) {
                return null;
            }
            if (binary.getOperator() instanceof AdditionOperator) {
                return left + right;
            }
            if (binary.getOperator() instanceof DivisionOperator) {
                return left == 0 ? null : Integer.valueOf(left / right);
            }
            if (binary.getOperator() instanceof Module) {
                return right == 0 ? null : Integer.valueOf(left % right);
            }
            if (binary.getOperator() instanceof Multiplication) {
                return left * right;
            }
            if (binary.getOperator() instanceof SubtractionOperator) {
                return left - right;
            }
        }
        return null;
    }

    public Collection<ConstantPropagation> gen(Identifier id, ValueExpression expression, ProgramPoint pp, DefiniteForwardDataflowDomain<ConstantPropagation> domain) {
        HashSet<ConstantPropagation> gen = new HashSet<ConstantPropagation>();
        Integer v = ConstantPropagation.eval((SymbolicExpression)expression, domain);
        if (v != null) {
            gen.add(new ConstantPropagation(id, v));
        }
        return gen;
    }

    public Collection<ConstantPropagation> gen(ValueExpression expression, ProgramPoint pp, DefiniteForwardDataflowDomain<ConstantPropagation> domain) {
        return Collections.emptyList();
    }

    public Collection<ConstantPropagation> kill(Identifier id, ValueExpression expression, ProgramPoint pp, DefiniteForwardDataflowDomain<ConstantPropagation> domain) {
        HashSet<ConstantPropagation> result = new HashSet<ConstantPropagation>();
        for (ConstantPropagation cp : domain.getDataflowElements()) {
            if (!cp.id.equals((Object)id)) continue;
            result.add(cp);
        }
        return result;
    }

    public Collection<ConstantPropagation> kill(ValueExpression expression, ProgramPoint pp, DefiniteForwardDataflowDomain<ConstantPropagation> domain) {
        return Collections.emptyList();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.constant == null ? 0 : this.constant.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstantPropagation other = (ConstantPropagation)obj;
        if (this.id == null ? other.id != null : !this.id.equals((Object)other.id)) {
            return false;
        }
        return !(this.constant == null ? other.constant != null : !this.constant.equals(other.constant));
    }

    public boolean tracksIdentifiers(Identifier id) {
        return !id.getDynamicType().isPointerType();
    }

    public boolean canProcess(SymbolicExpression expression) {
        return !expression.getDynamicType().isPointerType();
    }

    public DomainRepresentation representation() {
        return new PairRepresentation((DomainRepresentation)new StringRepresentation((Object)this.id), (DomainRepresentation)new StringRepresentation((Object)this.constant));
    }

    public ConstantPropagation pushScope(ScopeToken scope) throws SemanticException {
        return new ConstantPropagation((Identifier)this.id.pushScope(scope), this.constant);
    }

    public ConstantPropagation popScope(ScopeToken scope) throws SemanticException {
        if (!(this.id instanceof OutOfScopeIdentifier)) {
            return this;
        }
        return new ConstantPropagation(((OutOfScopeIdentifier)this.id).popScope(scope), this.constant);
    }
}

