/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.heap;

import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticDomain;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.heap.BaseHeapDomain;
import it.unive.lisa.analysis.heap.HeapSemanticOperation;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.representation.DomainRepresentation;
import it.unive.lisa.analysis.representation.StringRepresentation;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.ExpressionVisitor;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.heap.AccessChild;
import it.unive.lisa.symbolic.heap.HeapAllocation;
import it.unive.lisa.symbolic.heap.HeapDereference;
import it.unive.lisa.symbolic.heap.HeapExpression;
import it.unive.lisa.symbolic.heap.HeapReference;
import it.unive.lisa.symbolic.value.HeapLocation;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.MemoryPointer;
import it.unive.lisa.symbolic.value.ValueExpression;
import java.util.Collections;
import java.util.List;

public class MonolithicHeap
extends BaseHeapDomain<MonolithicHeap> {
    private static final MonolithicHeap TOP = new MonolithicHeap();
    private static final MonolithicHeap BOTTOM = new MonolithicHeap();
    private static final String MONOLITH_NAME = "heap";
    private static final DomainRepresentation REPR = new StringRepresentation("monolith");

    public ExpressionSet<ValueExpression> rewrite(SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        return (ExpressionSet)expression.accept((ExpressionVisitor)new Rewriter(), new Object[]{pp});
    }

    public List<HeapSemanticOperation.HeapReplacement> getSubstitution() {
        return Collections.emptyList();
    }

    public MonolithicHeap assign(Identifier id, SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        return this;
    }

    protected MonolithicHeap mk(MonolithicHeap reference) {
        return TOP;
    }

    protected MonolithicHeap semanticsOf(HeapExpression expression, ProgramPoint pp) {
        return this;
    }

    public MonolithicHeap assume(SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        return this;
    }

    public SemanticDomain.Satisfiability satisfies(SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        return SemanticDomain.Satisfiability.UNKNOWN;
    }

    public MonolithicHeap forgetIdentifier(Identifier id) throws SemanticException {
        return this;
    }

    protected MonolithicHeap lubAux(MonolithicHeap other) throws SemanticException {
        return TOP;
    }

    protected MonolithicHeap wideningAux(MonolithicHeap other) throws SemanticException {
        return TOP;
    }

    protected boolean lessOrEqualAux(MonolithicHeap other) throws SemanticException {
        return true;
    }

    public MonolithicHeap top() {
        return TOP;
    }

    public MonolithicHeap bottom() {
        return BOTTOM;
    }

    public DomainRepresentation representation() {
        return this.isBottom() ? Lattice.BOTTOM_REPR : REPR;
    }

    public int hashCode() {
        return MonolithicHeap.class.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        MonolithicHeap other = (MonolithicHeap)((Object)obj);
        return this.isTop() == other.isTop() && this.isBottom() == other.isBottom();
    }

    private static class Rewriter
    extends BaseHeapDomain.Rewriter {
        private Rewriter() {
        }

        public ExpressionSet<ValueExpression> visit(AccessChild expression, ExpressionSet<ValueExpression> receiver, ExpressionSet<ValueExpression> child, Object ... params) throws SemanticException {
            return new ExpressionSet((SymbolicExpression)new HeapLocation(expression.getTypes(), MonolithicHeap.MONOLITH_NAME, true, expression.getCodeLocation()));
        }

        public ExpressionSet<ValueExpression> visit(HeapAllocation expression, Object ... params) throws SemanticException {
            return new ExpressionSet((SymbolicExpression)new HeapLocation(expression.getTypes(), MonolithicHeap.MONOLITH_NAME, true, expression.getCodeLocation()));
        }

        public ExpressionSet<ValueExpression> visit(HeapReference expression, ExpressionSet<ValueExpression> ref, Object ... params) throws SemanticException {
            return new ExpressionSet((SymbolicExpression)new MemoryPointer(expression.getTypes(), new HeapLocation(expression.getTypes(), MonolithicHeap.MONOLITH_NAME, true, expression.getCodeLocation()), expression.getCodeLocation()));
        }

        public ExpressionSet<ValueExpression> visit(HeapDereference expression, ExpressionSet<ValueExpression> deref, Object ... params) throws SemanticException {
            return new ExpressionSet((SymbolicExpression)new MemoryPointer(expression.getTypes(), new HeapLocation(expression.getTypes(), MonolithicHeap.MONOLITH_NAME, true, expression.getCodeLocation()), expression.getCodeLocation()));
        }
    }
}

