/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.heap.pointbased;

import it.unive.lisa.analysis.SemanticDomain;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.heap.HeapSemanticOperation;
import it.unive.lisa.analysis.heap.pointbased.AllocationSite;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.lattices.SetLattice;
import it.unive.lisa.analysis.nonrelational.heap.HeapEnvironment;
import it.unive.lisa.analysis.nonrelational.heap.NonRelationalHeapDomain;
import it.unive.lisa.analysis.representation.DomainRepresentation;
import it.unive.lisa.analysis.representation.StringRepresentation;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.ValueExpression;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class AllocationSites
extends SetLattice<AllocationSites, AllocationSite>
implements NonRelationalHeapDomain<AllocationSites> {
    private static final AllocationSites TOP = new AllocationSites(new HashSet<AllocationSite>(), true);
    private static final AllocationSites BOTTOM = new AllocationSites(new HashSet<AllocationSite>(), false);
    private final boolean isTop;

    public AllocationSites() {
        this(new HashSet<AllocationSite>(), true);
    }

    AllocationSites(Set<AllocationSite> set, boolean isTop) {
        super(set);
        this.isTop = isTop;
    }

    public boolean isTop() {
        return this.isTop;
    }

    public boolean isBottom() {
        return !this.isTop && this.elements.isEmpty();
    }

    public AllocationSites top() {
        return TOP;
    }

    public AllocationSites bottom() {
        return BOTTOM;
    }

    protected AllocationSites mk(Set<AllocationSite> set) {
        return new AllocationSites(set, false);
    }

    public Iterator<AllocationSite> iterator() {
        return this.elements.iterator();
    }

    public AllocationSites eval(SymbolicExpression expression, HeapEnvironment<AllocationSites> environment, ProgramPoint pp) {
        return new AllocationSites(Collections.singleton((AllocationSite)expression), false);
    }

    public SemanticDomain.Satisfiability satisfies(SymbolicExpression expression, HeapEnvironment<AllocationSites> environment, ProgramPoint pp) {
        return SemanticDomain.Satisfiability.UNKNOWN;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.isTop ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AllocationSites other = (AllocationSites)((Object)obj);
        return this.isTop == other.isTop;
    }

    public DomainRepresentation representation() {
        return new StringRepresentation(this.toString());
    }

    public List<HeapSemanticOperation.HeapReplacement> getSubstitution() {
        return Collections.emptyList();
    }

    protected AllocationSites lubAux(AllocationSites other) throws SemanticException {
        HashMap lub = new HashMap();
        this.elements.stream().filter(Identifier::isWeak).forEach(e -> lub.put(e.getName(), e));
        other.elements.stream().filter(Identifier::isWeak).forEach(e -> lub.put(e.getName(), e));
        this.elements.stream().filter(Predicate.not(Identifier::isWeak)).filter(e -> !lub.containsKey(e.getName())).forEach(e -> lub.put(e.getName(), e));
        other.elements.stream().filter(Predicate.not(Identifier::isWeak)).filter(e -> !lub.containsKey(e.getName())).forEach(e -> lub.put(e.getName(), e));
        return new AllocationSites(new HashSet<AllocationSite>(lub.values()), false);
    }

    public boolean tracksIdentifiers(Identifier id) {
        return id.getDynamicType().isPointerType() || id.getDynamicType().isUntyped();
    }

    public boolean canProcess(SymbolicExpression expression) {
        return expression.getDynamicType().isPointerType() || expression.getDynamicType().isUntyped();
    }

    public HeapEnvironment<AllocationSites> assume(HeapEnvironment<AllocationSites> environment, SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        return environment;
    }

    public ExpressionSet<ValueExpression> rewrite(SymbolicExpression expression, HeapEnvironment<AllocationSites> environment, ProgramPoint pp) throws SemanticException {
        return new ExpressionSet();
    }
}

