/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.heap.pointbased;

import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.heap.pointbased.AllocationSite;
import it.unive.lisa.analysis.heap.pointbased.AllocationSites;
import it.unive.lisa.analysis.heap.pointbased.PointBasedHeap;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.nonrelational.heap.HeapEnvironment;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.ExpressionVisitor;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.heap.AccessChild;
import it.unive.lisa.symbolic.heap.HeapAllocation;
import it.unive.lisa.symbolic.value.MemoryPointer;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.type.Type;
import it.unive.lisa.util.collections.externalSet.ExternalSet;
import java.util.HashSet;
import java.util.Iterator;

public class FieldSensitivePointBasedHeap
extends PointBasedHeap {
    public FieldSensitivePointBasedHeap() {
    }

    private FieldSensitivePointBasedHeap(HeapEnvironment<AllocationSites> allocationSites) {
        super(allocationSites);
    }

    @Override
    protected FieldSensitivePointBasedHeap from(PointBasedHeap original) {
        return new FieldSensitivePointBasedHeap(original.heapEnv);
    }

    @Override
    public ExpressionSet<ValueExpression> rewrite(SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        return (ExpressionSet)expression.accept((ExpressionVisitor)new Rewriter(), new Object[0]);
    }

    private class Rewriter
    extends PointBasedHeap.Rewriter {
        private Rewriter() {
        }

        @Override
        public ExpressionSet<ValueExpression> visit(AccessChild expression, ExpressionSet<ValueExpression> receiver, ExpressionSet<ValueExpression> child, Object ... params) throws SemanticException {
            HashSet<AllocationSite> result = new HashSet<AllocationSite>();
            for (ValueExpression contRewritten : receiver) {
                if (!(contRewritten instanceof MemoryPointer)) continue;
                AllocationSite site = (AllocationSite)((MemoryPointer)contRewritten).getReferencedLocation();
                for (SymbolicExpression childRewritten : child) {
                    result.add(new AllocationSite((ExternalSet<Type>)expression.getTypes(), site.getLocationName(), childRewritten, site.isWeak(), site.getCodeLocation()));
                }
            }
            return new ExpressionSet(result);
        }

        @Override
        public ExpressionSet<ValueExpression> visit(HeapAllocation expression, Object ... params) throws SemanticException {
            String pp = expression.getCodeLocation().getCodeLocation();
            if (this.alreadyAllocated(pp) != null) {
                return new ExpressionSet((SymbolicExpression)new AllocationSite((ExternalSet<Type>)expression.getTypes(), pp, true, expression.getCodeLocation()));
            }
            return new ExpressionSet((SymbolicExpression)new AllocationSite((ExternalSet<Type>)expression.getTypes(), pp, false, expression.getCodeLocation()));
        }

        private AllocationSite alreadyAllocated(String id) {
            for (AllocationSites set : FieldSensitivePointBasedHeap.this.heapEnv.getValues()) {
                Iterator<AllocationSite> iterator = set.iterator();
                while (iterator.hasNext()) {
                    AllocationSite site = iterator.next();
                    if (!site.getLocationName().equals(id)) continue;
                    return site;
                }
            }
            return null;
        }
    }
}

