/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.nonInterference;

import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.nonrelational.inference.BaseInferredValue;
import it.unive.lisa.analysis.nonrelational.inference.InferenceSystem;
import it.unive.lisa.analysis.nonrelational.inference.InferredValue;
import it.unive.lisa.analysis.representation.DomainRepresentation;
import it.unive.lisa.analysis.representation.StringRepresentation;
import it.unive.lisa.program.annotations.Annotation;
import it.unive.lisa.program.annotations.Annotations;
import it.unive.lisa.program.annotations.matcher.AnnotationMatcher;
import it.unive.lisa.program.annotations.matcher.BasicAnnotationMatcher;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.symbolic.value.operator.binary.BinaryOperator;
import it.unive.lisa.symbolic.value.operator.ternary.TernaryOperator;
import it.unive.lisa.symbolic.value.operator.unary.UnaryOperator;
import java.util.IdentityHashMap;
import java.util.Map;

public class NonInterference
extends BaseInferredValue<NonInterference> {
    private static final Annotation LOW_CONF_ANNOTATION = new Annotation("lisa.ni.LowConfidentiality");
    private static final AnnotationMatcher LOW_CONF_MATCHER = new BasicAnnotationMatcher(LOW_CONF_ANNOTATION);
    private static final Annotation HIGH_INT_ANNOTATION = new Annotation("lisa.ni.HighIntegrity");
    private static final AnnotationMatcher HIGH_INT_MATCHER = new BasicAnnotationMatcher(HIGH_INT_ANNOTATION);
    private static final byte NI_BOTTOM = 0;
    private static final byte NI_LOW = 1;
    private static final byte NI_HIGH = 2;
    private final byte confidentiality;
    private final byte integrity;
    private final Map<ProgramPoint, NonInterference> guards;

    public NonInterference() {
        this(2, 1);
    }

    private NonInterference(byte confidentiality, byte integrity) {
        this.confidentiality = confidentiality;
        this.integrity = integrity;
        this.guards = new IdentityHashMap<ProgramPoint, NonInterference>();
    }

    public NonInterference top() {
        return new NonInterference(2, 1);
    }

    public boolean isTop() {
        return this.confidentiality == 2 && this.integrity == 1;
    }

    public NonInterference bottom() {
        return new NonInterference(0, 0);
    }

    public boolean isBottom() {
        return this.confidentiality == 0 && this.integrity == 0;
    }

    public boolean isHighConfidentiality() {
        return this.confidentiality == 2;
    }

    public boolean isLowConfidentiality() {
        return this.confidentiality == 1;
    }

    public boolean isHighIntegrity() {
        return this.integrity == 2;
    }

    public boolean isLowIntegrity() {
        return this.integrity == 1;
    }

    protected NonInterference lubAux(NonInterference other) throws SemanticException {
        byte confidentiality = this.isHighConfidentiality() || other.isHighConfidentiality() ? (byte)2 : 1;
        byte integrity = this.isLowIntegrity() || other.isLowIntegrity() ? (byte)1 : 2;
        return new NonInterference(confidentiality, integrity);
    }

    protected NonInterference wideningAux(NonInterference other) throws SemanticException {
        return this.lubAux(other);
    }

    protected boolean lessOrEqualAux(NonInterference other) throws SemanticException {
        boolean confidentiality = this.isLowConfidentiality() || this.confidentiality == other.confidentiality;
        boolean integrity = this.isHighIntegrity() || this.integrity == other.integrity;
        return confidentiality && integrity;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.confidentiality;
        result = 31 * result + (this.guards == null ? 0 : this.guards.hashCode());
        result = 31 * result + this.integrity;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        NonInterference other = (NonInterference)((Object)obj);
        if (this.confidentiality != other.confidentiality) {
            return false;
        }
        if (this.guards == null ? other.guards != null : !this.guards.equals(other.guards)) {
            return false;
        }
        return this.integrity == other.integrity;
    }

    public DomainRepresentation representation() {
        return this.isBottom() ? Lattice.BOTTOM_REPR : new StringRepresentation((this.isHighConfidentiality() ? "H" : "L") + (this.isHighIntegrity() ? "H" : "L"));
    }

    private NonInterference state(NonInterference state, ProgramPoint pp) throws SemanticException {
        IdentityHashMap<ProgramPoint, NonInterference> guards = new IdentityHashMap<ProgramPoint, NonInterference>();
        for (ProgramPoint guard : pp.getCFG().getGuards(pp)) {
            guards.put(guard, state.guards.getOrDefault(guard, this.bottom()));
        }
        NonInterference res = this.bottom();
        for (NonInterference guard : guards.values()) {
            res = (NonInterference)res.lub((BaseLattice)guard);
        }
        guards.forEach(res.guards::put);
        return res;
    }

    private static NonInterference mkLowHigh() {
        return new NonInterference(1, 2);
    }

    private static NonInterference mkLowLow() {
        return new NonInterference(1, 1);
    }

    private static NonInterference mkHighHigh() {
        return new NonInterference(2, 2);
    }

    private NonInterference mkHighLow() {
        return this.top();
    }

    protected InferredValue.InferredPair<NonInterference> evalNullConstant(NonInterference state, ProgramPoint pp) throws SemanticException {
        return new InferredValue.InferredPair((InferredValue)this, (InferredValue)NonInterference.mkLowHigh(), (InferredValue)this.state(state, pp));
    }

    protected InferredValue.InferredPair<NonInterference> evalNonNullConstant(Constant constant, NonInterference state, ProgramPoint pp) throws SemanticException {
        return new InferredValue.InferredPair((InferredValue)this, (InferredValue)NonInterference.mkLowHigh(), (InferredValue)this.state(state, pp));
    }

    protected InferredValue.InferredPair<NonInterference> evalUnaryExpression(UnaryOperator operator, NonInterference arg, NonInterference state, ProgramPoint pp) throws SemanticException {
        return new InferredValue.InferredPair((InferredValue)this, (InferredValue)arg, (InferredValue)this.state(state, pp));
    }

    protected InferredValue.InferredPair<NonInterference> evalBinaryExpression(BinaryOperator operator, NonInterference left, NonInterference right, NonInterference state, ProgramPoint pp) throws SemanticException {
        return new InferredValue.InferredPair((InferredValue)this, (InferredValue)((NonInterference)left.lub((BaseLattice)right)), (InferredValue)this.state(state, pp));
    }

    protected InferredValue.InferredPair<NonInterference> evalTernaryExpression(TernaryOperator operator, NonInterference left, NonInterference middle, NonInterference right, NonInterference state, ProgramPoint pp) throws SemanticException {
        return new InferredValue.InferredPair((InferredValue)this, (InferredValue)((NonInterference)((NonInterference)left.lub((BaseLattice)middle)).lub((BaseLattice)right)), (InferredValue)this.state(state, pp));
    }

    protected InferredValue.InferredPair<NonInterference> evalIdentifier(Identifier id, InferenceSystem<NonInterference> environment, ProgramPoint pp) throws SemanticException {
        return new InferredValue.InferredPair((InferredValue)this, (InferredValue)this.variable(id, null), (InferredValue)this.state((NonInterference)environment.getExecutionState(), pp));
    }

    public NonInterference variable(Identifier id, ProgramPoint pp) {
        Annotations annots = id.getAnnotations();
        if (annots.isEmpty()) {
            return this.mkHighLow();
        }
        boolean lowConf = annots.contains(LOW_CONF_MATCHER);
        boolean highInt = annots.contains(HIGH_INT_MATCHER);
        if (lowConf && highInt) {
            return NonInterference.mkLowHigh();
        }
        if (lowConf) {
            return NonInterference.mkLowLow();
        }
        if (highInt) {
            return NonInterference.mkHighHigh();
        }
        return this.mkHighLow();
    }

    public boolean tracksIdentifiers(Identifier id) {
        return true;
    }

    public boolean canProcess(SymbolicExpression expression) {
        return !expression.getDynamicType().isPointerType();
    }

    public InferenceSystem<NonInterference> assume(InferenceSystem<NonInterference> environment, ValueExpression expression, ProgramPoint pp) throws SemanticException {
        InferredValue.InferredPair eval = this.eval(expression, environment, pp);
        NonInterference inf = (NonInterference)eval.getInferred();
        ((NonInterference)eval.getState()).guards.forEach(inf.guards::put);
        inf.guards.put(pp, inf);
        return new InferenceSystem(environment, (InferredValue)inf);
    }
}

