/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.numeric;

import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticDomain;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.nonrelational.value.BaseNonRelationalValueDomain;
import it.unive.lisa.analysis.nonrelational.value.ValueEnvironment;
import it.unive.lisa.analysis.representation.DomainRepresentation;
import it.unive.lisa.analysis.representation.StringRepresentation;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.symbolic.value.operator.AdditionOperator;
import it.unive.lisa.symbolic.value.operator.DivisionOperator;
import it.unive.lisa.symbolic.value.operator.Multiplication;
import it.unive.lisa.symbolic.value.operator.SubtractionOperator;
import it.unive.lisa.symbolic.value.operator.binary.BinaryOperator;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonEq;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonGe;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonGt;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonLe;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonLt;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonNe;
import it.unive.lisa.symbolic.value.operator.unary.NumericNegation;
import it.unive.lisa.symbolic.value.operator.unary.StringLength;
import it.unive.lisa.symbolic.value.operator.unary.UnaryOperator;
import it.unive.lisa.util.numeric.IntInterval;
import it.unive.lisa.util.numeric.MathNumber;

public class Interval
extends BaseNonRelationalValueDomain<Interval> {
    private static final Interval ZERO = new Interval(IntInterval.ZERO);
    private static final Interval TOP = new Interval(IntInterval.INFINITY);
    private static final Interval BOTTOM = new Interval(null);
    final IntInterval interval;

    private Interval(IntInterval interval) {
        this.interval = interval;
    }

    private Interval(MathNumber low, MathNumber high) {
        this(new IntInterval(low, high));
    }

    public Interval() {
        this(IntInterval.INFINITY);
    }

    public Interval top() {
        return TOP;
    }

    public boolean isTop() {
        return this.interval != null && this.interval.isInfinity();
    }

    public Interval bottom() {
        return BOTTOM;
    }

    public boolean isBottom() {
        return this.interval == null;
    }

    public DomainRepresentation representation() {
        if (this.isBottom()) {
            return Lattice.BOTTOM_REPR;
        }
        return new StringRepresentation(this.interval.toString());
    }

    protected Interval evalNonNullConstant(Constant constant, ProgramPoint pp) {
        if (constant.getValue() instanceof Integer) {
            Integer i = (Integer)constant.getValue();
            return new Interval(new MathNumber((long)i.intValue()), new MathNumber((long)i.intValue()));
        }
        return this.top();
    }

    protected Interval evalUnaryExpression(UnaryOperator operator, Interval arg, ProgramPoint pp) {
        if (operator == NumericNegation.INSTANCE) {
            if (arg.isTop()) {
                return this.top();
            }
            return new Interval(arg.interval.mul(IntInterval.MINUS_ONE));
        }
        if (operator == StringLength.INSTANCE) {
            return new Interval(MathNumber.ZERO, MathNumber.PLUS_INFINITY);
        }
        return this.top();
    }

    private boolean is(int n) {
        return !this.isBottom() && this.interval.is(n);
    }

    protected Interval evalBinaryExpression(BinaryOperator operator, Interval left, Interval right, ProgramPoint pp) {
        if (!(operator instanceof DivisionOperator) && (left.isTop() || right.isTop())) {
            return this.top();
        }
        if (operator instanceof AdditionOperator) {
            return new Interval(left.interval.plus(right.interval));
        }
        if (operator instanceof SubtractionOperator) {
            return new Interval(left.interval.diff(right.interval));
        }
        if (operator instanceof Multiplication) {
            if (left.is(0) || right.is(0)) {
                return ZERO;
            }
            return new Interval(left.interval.mul(right.interval));
        }
        if (operator instanceof DivisionOperator) {
            if (right.is(0)) {
                return this.bottom();
            }
            if (left.is(0)) {
                return ZERO;
            }
            if (left.isTop() || right.isTop()) {
                return this.top();
            }
            return new Interval(left.interval.div(right.interval, false, false));
        }
        return this.top();
    }

    protected Interval lubAux(Interval other) throws SemanticException {
        MathNumber newLow = this.interval.getLow().min(other.interval.getLow());
        MathNumber newHigh = this.interval.getHigh().max(other.interval.getHigh());
        return newLow.isMinusInfinity() && newHigh.isPlusInfinity() ? this.top() : new Interval(newLow, newHigh);
    }

    protected Interval glbAux(Interval other) {
        MathNumber newHigh;
        MathNumber newLow = this.interval.getLow().max(other.interval.getLow());
        if (newLow.compareTo(newHigh = this.interval.getHigh().min(other.interval.getHigh())) > 0) {
            return this.bottom();
        }
        return newLow.isMinusInfinity() && newHigh.isPlusInfinity() ? this.top() : new Interval(newLow, newHigh);
    }

    protected Interval wideningAux(Interval other) throws SemanticException {
        MathNumber newHigh = other.interval.getHigh().compareTo(this.interval.getHigh()) > 0 ? MathNumber.PLUS_INFINITY : this.interval.getHigh();
        MathNumber newLow = other.interval.getLow().compareTo(this.interval.getLow()) < 0 ? MathNumber.MINUS_INFINITY : this.interval.getLow();
        return newLow.isMinusInfinity() && newHigh.isPlusInfinity() ? this.top() : new Interval(newLow, newHigh);
    }

    protected boolean lessOrEqualAux(Interval other) throws SemanticException {
        return other.interval.includes(this.interval);
    }

    protected SemanticDomain.Satisfiability satisfiesBinaryExpression(BinaryOperator operator, Interval left, Interval right, ProgramPoint pp) {
        if (left.isTop() || right.isTop()) {
            return SemanticDomain.Satisfiability.UNKNOWN;
        }
        if (operator == ComparisonEq.INSTANCE) {
            Interval glb = null;
            try {
                glb = (Interval)left.glb(right);
            }
            catch (SemanticException e) {
                return SemanticDomain.Satisfiability.UNKNOWN;
            }
            if (glb.isBottom()) {
                return SemanticDomain.Satisfiability.NOT_SATISFIED;
            }
            if (left.interval.isSingleton() && left.equals((Object)right)) {
                return SemanticDomain.Satisfiability.SATISFIED;
            }
            return SemanticDomain.Satisfiability.UNKNOWN;
        }
        if (operator == ComparisonGe.INSTANCE) {
            return this.satisfiesBinaryExpression((BinaryOperator)ComparisonLt.INSTANCE, right, left, pp);
        }
        if (operator == ComparisonGt.INSTANCE) {
            return this.satisfiesBinaryExpression((BinaryOperator)ComparisonLe.INSTANCE, right, left, pp);
        }
        if (operator == ComparisonLe.INSTANCE) {
            Interval glb = null;
            try {
                glb = (Interval)left.glb(right);
            }
            catch (SemanticException e) {
                return SemanticDomain.Satisfiability.UNKNOWN;
            }
            if (glb.isBottom()) {
                return SemanticDomain.Satisfiability.fromBoolean((left.interval.getHigh().compareTo(right.interval.getLow()) <= 0 ? 1 : 0) != 0);
            }
            if (glb.interval.isSingleton() && left.interval.getHigh().compareTo(right.interval.getLow()) == 0) {
                return SemanticDomain.Satisfiability.SATISFIED;
            }
            return SemanticDomain.Satisfiability.UNKNOWN;
        }
        if (operator == ComparisonLt.INSTANCE) {
            Interval glb = null;
            try {
                glb = (Interval)left.glb(right);
            }
            catch (SemanticException e) {
                return SemanticDomain.Satisfiability.UNKNOWN;
            }
            if (glb.isBottom()) {
                return SemanticDomain.Satisfiability.fromBoolean((left.interval.getHigh().compareTo(right.interval.getLow()) < 0 ? 1 : 0) != 0);
            }
            return SemanticDomain.Satisfiability.UNKNOWN;
        }
        if (operator == ComparisonNe.INSTANCE) {
            Interval glb = null;
            try {
                glb = (Interval)left.glb(right);
            }
            catch (SemanticException e) {
                return SemanticDomain.Satisfiability.UNKNOWN;
            }
            if (glb.isBottom()) {
                return SemanticDomain.Satisfiability.SATISFIED;
            }
            return SemanticDomain.Satisfiability.UNKNOWN;
        }
        return SemanticDomain.Satisfiability.UNKNOWN;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.interval == null ? 0 : this.interval.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Interval other = (Interval)((Object)obj);
        return !(this.interval == null ? other.interval != null : !this.interval.equals((Object)other.interval));
    }

    protected ValueEnvironment<Interval> assumeBinaryExpression(ValueEnvironment<Interval> environment, BinaryOperator operator, ValueExpression left, ValueExpression right, ProgramPoint pp) throws SemanticException {
        boolean rightIsExpr;
        Identifier id;
        Interval eval;
        if (left instanceof Identifier) {
            eval = (Interval)this.eval(right, environment, pp);
            id = (Identifier)left;
            rightIsExpr = true;
        } else if (right instanceof Identifier) {
            eval = (Interval)this.eval(left, environment, pp);
            id = (Identifier)right;
            rightIsExpr = false;
        } else {
            return environment;
        }
        if (eval.isBottom()) {
            return environment.bottom();
        }
        boolean lowIsMinusInfinity = eval.interval.lowIsMinusInfinity();
        Interval low_inf = new Interval(eval.interval.getLow(), MathNumber.PLUS_INFINITY);
        Interval lowp1_inf = new Interval(eval.interval.getLow().add(MathNumber.ONE), MathNumber.PLUS_INFINITY);
        Interval inf_high = new Interval(MathNumber.MINUS_INFINITY, eval.interval.getHigh());
        Interval inf_highm1 = new Interval(MathNumber.MINUS_INFINITY, eval.interval.getHigh().subtract(MathNumber.ONE));
        if (operator == ComparisonEq.INSTANCE) {
            return (ValueEnvironment)environment.putState((Object)id, (Lattice)eval);
        }
        if (operator == ComparisonGe.INSTANCE) {
            if (rightIsExpr) {
                return lowIsMinusInfinity ? environment : (ValueEnvironment)environment.putState((Object)id, (Lattice)low_inf);
            }
            return (ValueEnvironment)environment.putState((Object)id, (Lattice)inf_high);
        }
        if (operator == ComparisonGt.INSTANCE) {
            if (rightIsExpr) {
                return lowIsMinusInfinity ? environment : (ValueEnvironment)environment.putState((Object)id, (Lattice)lowp1_inf);
            }
            return (ValueEnvironment)environment.putState((Object)id, (Lattice)(lowIsMinusInfinity ? eval : inf_highm1));
        }
        if (operator == ComparisonLe.INSTANCE) {
            if (rightIsExpr) {
                return (ValueEnvironment)environment.putState((Object)id, (Lattice)inf_high);
            }
            return lowIsMinusInfinity ? environment : (ValueEnvironment)environment.putState((Object)id, (Lattice)low_inf);
        }
        if (operator == ComparisonLt.INSTANCE) {
            if (rightIsExpr) {
                return (ValueEnvironment)environment.putState((Object)id, (Lattice)(lowIsMinusInfinity ? eval : inf_highm1));
            }
            return lowIsMinusInfinity ? environment : (ValueEnvironment)environment.putState((Object)id, (Lattice)lowp1_inf);
        }
        return environment;
    }
}

