/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.numeric;

import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.nonrelational.value.BaseNonRelationalValueDomain;
import it.unive.lisa.analysis.nonrelational.value.ValueEnvironment;
import it.unive.lisa.analysis.representation.DomainRepresentation;
import it.unive.lisa.analysis.representation.StringRepresentation;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.symbolic.value.operator.AdditionOperator;
import it.unive.lisa.symbolic.value.operator.DivisionOperator;
import it.unive.lisa.symbolic.value.operator.Module;
import it.unive.lisa.symbolic.value.operator.Multiplication;
import it.unive.lisa.symbolic.value.operator.SubtractionOperator;
import it.unive.lisa.symbolic.value.operator.binary.BinaryOperator;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonEq;
import it.unive.lisa.symbolic.value.operator.unary.NumericNegation;
import it.unive.lisa.symbolic.value.operator.unary.UnaryOperator;

public class Parity
extends BaseNonRelationalValueDomain<Parity> {
    private static final Parity EVEN = new Parity(3);
    private static final Parity ODD = new Parity(2);
    private static final Parity TOP = new Parity(0);
    private static final Parity BOTTOM = new Parity(1);
    private final byte parity;

    public Parity() {
        this(0);
    }

    private Parity(byte parity) {
        this.parity = parity;
    }

    public Parity top() {
        return TOP;
    }

    public Parity bottom() {
        return BOTTOM;
    }

    public DomainRepresentation representation() {
        if (this.isBottom()) {
            return Lattice.BOTTOM_REPR;
        }
        if (this.isTop()) {
            return Lattice.TOP_REPR;
        }
        String repr = this == EVEN ? "Even" : "Odd";
        return new StringRepresentation(repr);
    }

    protected Parity evalNullConstant(ProgramPoint pp) {
        return this.top();
    }

    protected Parity evalNonNullConstant(Constant constant, ProgramPoint pp) {
        if (constant.getValue() instanceof Integer) {
            Integer i = (Integer)constant.getValue();
            return i % 2 == 0 ? EVEN : ODD;
        }
        return this.top();
    }

    private boolean isEven() {
        return this == EVEN;
    }

    private boolean isOdd() {
        return this == ODD;
    }

    protected Parity evalUnaryExpression(UnaryOperator operator, Parity arg, ProgramPoint pp) {
        if (operator == NumericNegation.INSTANCE) {
            return arg;
        }
        return this.top();
    }

    protected Parity evalBinaryExpression(BinaryOperator operator, Parity left, Parity right, ProgramPoint pp) {
        if (left.isTop() || right.isTop()) {
            return this.top();
        }
        if (operator instanceof AdditionOperator || operator instanceof SubtractionOperator) {
            if (right.equals((Object)left)) {
                return EVEN;
            }
            return ODD;
        }
        if (operator instanceof Multiplication) {
            if (left.isEven() || right.isEven()) {
                return EVEN;
            }
            return ODD;
        }
        if (operator instanceof DivisionOperator) {
            if (left.isOdd()) {
                return right.isOdd() ? ODD : EVEN;
            }
            return right.isOdd() ? EVEN : TOP;
        }
        if (operator instanceof Module) {
            return TOP;
        }
        return TOP;
    }

    protected Parity lubAux(Parity other) throws SemanticException {
        return TOP;
    }

    protected Parity wideningAux(Parity other) throws SemanticException {
        return this.lubAux(other);
    }

    protected boolean lessOrEqualAux(Parity other) throws SemanticException {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.parity;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Parity other = (Parity)((Object)obj);
        return this.parity == other.parity;
    }

    protected ValueEnvironment<Parity> assumeBinaryExpression(ValueEnvironment<Parity> environment, BinaryOperator operator, ValueExpression left, ValueExpression right, ProgramPoint pp) throws SemanticException {
        if (operator == ComparisonEq.INSTANCE) {
            if (left instanceof Identifier) {
                environment = (ValueEnvironment)environment.assign((Identifier)left, (SymbolicExpression)right, pp);
            } else if (right instanceof Identifier) {
                environment = (ValueEnvironment)environment.assign((Identifier)right, (SymbolicExpression)left, pp);
            }
            return environment;
        }
        return environment;
    }
}

