/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.numeric;

import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticDomain;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.nonrelational.value.BaseNonRelationalValueDomain;
import it.unive.lisa.analysis.nonrelational.value.ValueEnvironment;
import it.unive.lisa.analysis.representation.DomainRepresentation;
import it.unive.lisa.analysis.representation.StringRepresentation;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.symbolic.value.operator.AdditionOperator;
import it.unive.lisa.symbolic.value.operator.DivisionOperator;
import it.unive.lisa.symbolic.value.operator.Module;
import it.unive.lisa.symbolic.value.operator.Multiplication;
import it.unive.lisa.symbolic.value.operator.SubtractionOperator;
import it.unive.lisa.symbolic.value.operator.binary.BinaryOperator;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonEq;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonGe;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonGt;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonLe;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonLt;
import it.unive.lisa.symbolic.value.operator.ternary.TernaryOperator;
import it.unive.lisa.symbolic.value.operator.unary.NumericNegation;
import it.unive.lisa.symbolic.value.operator.unary.UnaryOperator;

public class Sign
extends BaseNonRelationalValueDomain<Sign> {
    private static final Sign POS = new Sign(4);
    private static final Sign NEG = new Sign(3);
    private static final Sign ZERO = new Sign(2);
    private static final Sign TOP = new Sign(0);
    private static final Sign BOTTOM = new Sign(1);
    private final byte sign;

    public Sign() {
        this(0);
    }

    private Sign(byte sign) {
        this.sign = sign;
    }

    public Sign top() {
        return TOP;
    }

    public Sign bottom() {
        return BOTTOM;
    }

    public DomainRepresentation representation() {
        if (this.isBottom()) {
            return Lattice.BOTTOM_REPR;
        }
        if (this.isTop()) {
            return Lattice.TOP_REPR;
        }
        String repr = this == ZERO ? "0" : (this == POS ? "+" : "-");
        return new StringRepresentation(repr);
    }

    protected Sign evalNullConstant(ProgramPoint pp) {
        return this.top();
    }

    protected Sign evalNonNullConstant(Constant constant, ProgramPoint pp) {
        if (constant.getValue() instanceof Integer) {
            Integer i = (Integer)constant.getValue();
            return i == 0 ? ZERO : (i > 0 ? POS : NEG);
        }
        return this.top();
    }

    private boolean isPositive() {
        return this == POS;
    }

    private boolean isZero() {
        return this == ZERO;
    }

    private boolean isNegative() {
        return this == NEG;
    }

    private Sign opposite() {
        if (this.isTop() || this.isBottom()) {
            return this;
        }
        return this.isPositive() ? NEG : (this.isNegative() ? POS : ZERO);
    }

    protected Sign evalUnaryExpression(UnaryOperator operator, Sign arg, ProgramPoint pp) {
        if (operator == NumericNegation.INSTANCE) {
            if (arg.isPositive()) {
                return NEG;
            }
            if (arg.isNegative()) {
                return POS;
            }
            if (arg.isZero()) {
                return ZERO;
            }
            return TOP;
        }
        return TOP;
    }

    protected Sign evalBinaryExpression(BinaryOperator operator, Sign left, Sign right, ProgramPoint pp) {
        if (operator instanceof AdditionOperator) {
            if (left.isZero()) {
                return right;
            }
            if (right.isZero()) {
                return left;
            }
            if (left.equals((Object)right)) {
                return left;
            }
            return this.top();
        }
        if (operator instanceof SubtractionOperator) {
            if (left.isZero()) {
                return right.opposite();
            }
            if (right.isZero()) {
                return left.opposite();
            }
            if (left.equals((Object)right)) {
                return this.top();
            }
            return left;
        }
        if (operator instanceof DivisionOperator) {
            if (right.isZero()) {
                return this.bottom();
            }
            if (left.isZero()) {
                return ZERO;
            }
            if (left.equals((Object)right)) {
                return left.isTop() ? left : POS;
            }
            return this.top();
        }
        if (operator instanceof Module) {
            return this.top();
        }
        if (operator instanceof Multiplication) {
            if (left.isZero() || right.isZero()) {
                return ZERO;
            }
            if (left.equals((Object)right)) {
                return POS;
            }
            return NEG;
        }
        return TOP;
    }

    protected Sign lubAux(Sign other) throws SemanticException {
        return TOP;
    }

    protected Sign wideningAux(Sign other) throws SemanticException {
        return this.lubAux(other);
    }

    protected boolean lessOrEqualAux(Sign other) throws SemanticException {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.sign;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Sign other = (Sign)((Object)obj);
        return this.sign == other.sign;
    }

    protected SemanticDomain.Satisfiability satisfiesBinaryExpression(BinaryOperator operator, Sign left, Sign right, ProgramPoint pp) {
        if (left.isTop() || right.isTop()) {
            return SemanticDomain.Satisfiability.UNKNOWN;
        }
        if (operator == ComparisonEq.INSTANCE) {
            return left.eq(right);
        }
        if (operator == ComparisonGe.INSTANCE) {
            return left.eq(right).or(left.gt(right));
        }
        if (operator == ComparisonGt.INSTANCE) {
            return left.gt(right);
        }
        if (operator == ComparisonLe.INSTANCE) {
            return left.gt(right).negate();
        }
        if (operator == ComparisonLt.INSTANCE) {
            return left.gt(right).negate().and(left.eq(right).negate());
        }
        if (operator == ComparisonLe.INSTANCE) {
            return left.eq(right).negate();
        }
        return SemanticDomain.Satisfiability.UNKNOWN;
    }

    private SemanticDomain.Satisfiability eq(Sign other) {
        if (!this.equals((Object)other)) {
            return SemanticDomain.Satisfiability.NOT_SATISFIED;
        }
        if (this.isZero()) {
            return SemanticDomain.Satisfiability.SATISFIED;
        }
        return SemanticDomain.Satisfiability.UNKNOWN;
    }

    private SemanticDomain.Satisfiability gt(Sign other) {
        if (this.equals((Object)other)) {
            return this.isZero() ? SemanticDomain.Satisfiability.NOT_SATISFIED : SemanticDomain.Satisfiability.UNKNOWN;
        }
        if (this.isZero()) {
            return other.isPositive() ? SemanticDomain.Satisfiability.NOT_SATISFIED : SemanticDomain.Satisfiability.SATISFIED;
        }
        if (this.isPositive()) {
            return SemanticDomain.Satisfiability.SATISFIED;
        }
        return SemanticDomain.Satisfiability.NOT_SATISFIED;
    }

    protected SemanticDomain.Satisfiability satisfiesTernaryExpression(TernaryOperator operator, Sign left, Sign middle, Sign right, ProgramPoint pp) {
        return SemanticDomain.Satisfiability.UNKNOWN;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ValueEnvironment<Sign> assumeBinaryExpression(ValueEnvironment<Sign> environment, BinaryOperator operator, ValueExpression left, ValueExpression right, ProgramPoint pp) throws SemanticException {
        if (operator == ComparisonEq.INSTANCE) {
            if (left instanceof Identifier) {
                return (ValueEnvironment)environment.assign((Identifier)left, (SymbolicExpression)right, pp);
            }
            if (!(right instanceof Identifier)) return environment;
            return (ValueEnvironment)environment.assign((Identifier)right, (SymbolicExpression)left, pp);
        }
        if (operator == ComparisonGe.INSTANCE) {
            if (left instanceof Identifier) {
                Sign rightSign = (Sign)this.eval(right, environment, pp);
                if (!rightSign.isPositive()) return environment;
                return (ValueEnvironment)environment.assign((Identifier)left, (SymbolicExpression)right, pp);
            }
            if (!(right instanceof Identifier)) return environment;
            Sign leftSign = (Sign)this.eval(left, environment, pp);
            if (!leftSign.isNegative()) return environment;
            return (ValueEnvironment)environment.assign((Identifier)right, (SymbolicExpression)left, pp);
        }
        if (operator == ComparisonLe.INSTANCE) {
            if (left instanceof Identifier) {
                Sign rightSign = (Sign)this.eval(right, environment, pp);
                if (!rightSign.isNegative()) return environment;
                return (ValueEnvironment)environment.assign((Identifier)left, (SymbolicExpression)right, pp);
            }
            if (!(right instanceof Identifier)) return environment;
            Sign leftSign = (Sign)this.eval(left, environment, pp);
            if (!leftSign.isPositive()) return environment;
            return (ValueEnvironment)environment.assign((Identifier)right, (SymbolicExpression)left, pp);
        }
        if (operator == ComparisonLt.INSTANCE) {
            if (left instanceof Identifier) {
                Sign rightSign = (Sign)this.eval(right, environment, pp);
                if (rightSign.isNegative()) return (ValueEnvironment)environment.assign((Identifier)left, (SymbolicExpression)new Constant(right.getDynamicType(), (Object)-1, right.getCodeLocation()), pp);
                if (!rightSign.isZero()) return environment;
                return (ValueEnvironment)environment.assign((Identifier)left, (SymbolicExpression)new Constant(right.getDynamicType(), (Object)-1, right.getCodeLocation()), pp);
            }
            if (!(right instanceof Identifier)) return environment;
            Sign leftSign = (Sign)this.eval(left, environment, pp);
            if (leftSign.isPositive()) return (ValueEnvironment)environment.assign((Identifier)right, (SymbolicExpression)new Constant(left.getDynamicType(), (Object)1, left.getCodeLocation()), pp);
            if (!leftSign.isZero()) return environment;
            return (ValueEnvironment)environment.assign((Identifier)right, (SymbolicExpression)new Constant(left.getDynamicType(), (Object)1, left.getCodeLocation()), pp);
        }
        if (operator != ComparisonGt.INSTANCE) return environment;
        if (left instanceof Identifier) {
            Sign rightSign = (Sign)this.eval(right, environment, pp);
            if (rightSign.isPositive()) return (ValueEnvironment)environment.assign((Identifier)left, (SymbolicExpression)new Constant(right.getDynamicType(), (Object)1, right.getCodeLocation()), pp);
            if (!rightSign.isZero()) return environment;
            return (ValueEnvironment)environment.assign((Identifier)left, (SymbolicExpression)new Constant(right.getDynamicType(), (Object)1, right.getCodeLocation()), pp);
        }
        if (!(right instanceof Identifier)) return environment;
        Sign leftSign = (Sign)this.eval(left, environment, pp);
        if (leftSign.isNegative()) return (ValueEnvironment)environment.assign((Identifier)right, (SymbolicExpression)new Constant(left.getDynamicType(), (Object)-1, right.getCodeLocation()), pp);
        if (!leftSign.isZero()) return environment;
        return (ValueEnvironment)environment.assign((Identifier)right, (SymbolicExpression)new Constant(left.getDynamicType(), (Object)-1, right.getCodeLocation()), pp);
    }
}

