/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.types;

import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticDomain;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.nonrelational.inference.BaseInferredValue;
import it.unive.lisa.analysis.nonrelational.inference.InferenceSystem;
import it.unive.lisa.analysis.nonrelational.inference.InferredValue;
import it.unive.lisa.analysis.representation.DomainRepresentation;
import it.unive.lisa.analysis.representation.SetRepresentation;
import it.unive.lisa.analysis.representation.StringRepresentation;
import it.unive.lisa.caches.Caches;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.BinaryExpression;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.MemoryPointer;
import it.unive.lisa.symbolic.value.PushAny;
import it.unive.lisa.symbolic.value.operator.binary.BinaryOperator;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonEq;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonNe;
import it.unive.lisa.symbolic.value.operator.binary.TypeCast;
import it.unive.lisa.symbolic.value.operator.binary.TypeCheck;
import it.unive.lisa.symbolic.value.operator.ternary.TernaryOperator;
import it.unive.lisa.symbolic.value.operator.unary.UnaryOperator;
import it.unive.lisa.type.NullType;
import it.unive.lisa.type.Type;
import it.unive.lisa.util.collections.externalSet.ExternalSet;
import java.util.concurrent.atomic.AtomicBoolean;

public class InferredTypes
extends BaseInferredValue<InferredTypes> {
    private static final InferredTypes TOP = new InferredTypes((ExternalSet<Type>)Caches.types().mkUniversalSet());
    private static final InferredTypes BOTTOM = new InferredTypes((ExternalSet<Type>)Caches.types().mkEmptySet());
    private static final InferredValue.InferredPair<InferredTypes> BOTTOM_PAIR = new InferredValue.InferredPair((InferredValue)BOTTOM, (InferredValue)BOTTOM, (InferredValue)BOTTOM);
    private final ExternalSet<Type> elements;

    public InferredTypes() {
        this((ExternalSet<Type>)Caches.types().mkEmptySet());
    }

    InferredTypes(Type type) {
        this((ExternalSet<Type>)Caches.types().mkSingletonSet((Object)type));
    }

    InferredTypes(ExternalSet<Type> types) {
        this.elements = types;
    }

    public ExternalSet<Type> getRuntimeTypes() {
        return this.elements;
    }

    public InferredTypes top() {
        return TOP;
    }

    public InferredTypes bottom() {
        return BOTTOM;
    }

    public DomainRepresentation representation() {
        if (this.isTop()) {
            return Lattice.TOP_REPR;
        }
        if (this.isBottom()) {
            return Lattice.BOTTOM_REPR;
        }
        return new SetRepresentation(this.elements, StringRepresentation::new);
    }

    private InferredValue.InferredPair<InferredTypes> mk(InferredTypes types) {
        return new InferredValue.InferredPair((InferredValue)this, (InferredValue)types, (InferredValue)BOTTOM);
    }

    protected InferredValue.InferredPair<InferredTypes> evalIdentifier(Identifier id, InferenceSystem<InferredTypes> environment, ProgramPoint pp) throws SemanticException {
        InferredValue.InferredPair eval = super.evalIdentifier(id, environment, pp);
        if (!((InferredTypes)eval.getInferred()).isTop() && !((InferredTypes)eval.getInferred()).isBottom()) {
            return eval;
        }
        return this.mk(new InferredTypes((ExternalSet<Type>)id.getTypes()));
    }

    protected InferredValue.InferredPair<InferredTypes> evalPushAny(PushAny pushAny, InferredTypes state, ProgramPoint pp) {
        return this.mk(new InferredTypes((ExternalSet<Type>)pushAny.getTypes()));
    }

    protected InferredValue.InferredPair<InferredTypes> evalNullConstant(InferredTypes state, ProgramPoint pp) {
        return this.mk(new InferredTypes((Type)NullType.INSTANCE));
    }

    protected InferredValue.InferredPair<InferredTypes> evalNonNullConstant(Constant constant, InferredTypes state, ProgramPoint pp) {
        return this.mk(new InferredTypes(constant.getDynamicType()));
    }

    protected InferredValue.InferredPair<InferredTypes> evalUnaryExpression(UnaryOperator operator, InferredTypes arg, InferredTypes state, ProgramPoint pp) {
        ExternalSet inferred = operator.typeInference(arg.elements);
        if (inferred.isEmpty()) {
            return BOTTOM_PAIR;
        }
        return this.mk(new InferredTypes((ExternalSet<Type>)inferred));
    }

    protected InferredValue.InferredPair<InferredTypes> evalBinaryExpression(BinaryOperator operator, InferredTypes left, InferredTypes right, InferredTypes state, ProgramPoint pp) {
        ExternalSet inferred = operator.typeInference(left.elements, right.elements);
        if (inferred.isEmpty()) {
            return BOTTOM_PAIR;
        }
        return this.mk(new InferredTypes((ExternalSet<Type>)inferred));
    }

    protected InferredValue.InferredPair<InferredTypes> evalTernaryExpression(TernaryOperator operator, InferredTypes left, InferredTypes middle, InferredTypes right, InferredTypes state, ProgramPoint pp) {
        ExternalSet inferred = operator.typeInference(left.elements, middle.elements, right.elements);
        if (inferred.isEmpty()) {
            return BOTTOM_PAIR;
        }
        return this.mk(new InferredTypes((ExternalSet<Type>)inferred));
    }

    protected SemanticDomain.Satisfiability satisfiesBinaryExpression(BinaryOperator operator, InferredTypes left, InferredTypes right, InferredTypes state, ProgramPoint pp) {
        if (operator == ComparisonEq.INSTANCE || operator == ComparisonNe.INSTANCE) {
            if (!left.elements.allMatch(Type::isTypeTokenType) || !right.elements.allMatch(Type::isTypeTokenType)) {
                return SemanticDomain.Satisfiability.UNKNOWN;
            }
            ExternalSet lfiltered = left.elements.filter(Type::isTypeTokenType);
            ExternalSet rfiltered = right.elements.filter(Type::isTypeTokenType);
            if (operator == ComparisonEq.INSTANCE) {
                if (left.elements.size() == 1 && left.elements.equals(right.elements)) {
                    return SemanticDomain.Satisfiability.SATISFIED;
                }
                if (!left.elements.intersects(right.elements) && !InferredTypes.typeTokensIntersect((ExternalSet<Type>)lfiltered, (ExternalSet<Type>)rfiltered)) {
                    return SemanticDomain.Satisfiability.NOT_SATISFIED;
                }
                return SemanticDomain.Satisfiability.UNKNOWN;
            }
            if (!left.elements.intersects(right.elements) && !InferredTypes.typeTokensIntersect((ExternalSet<Type>)lfiltered, (ExternalSet<Type>)rfiltered)) {
                return SemanticDomain.Satisfiability.SATISFIED;
            }
            if (left.elements.size() == 1 && left.elements.equals(right.elements)) {
                return SemanticDomain.Satisfiability.NOT_SATISFIED;
            }
            return SemanticDomain.Satisfiability.UNKNOWN;
        }
        if (operator == TypeCheck.INSTANCE) {
            if (this.evalBinaryExpression((BinaryOperator)TypeCast.INSTANCE, left, right, state, pp).isBottom()) {
                return SemanticDomain.Satisfiability.NOT_SATISFIED;
            }
            AtomicBoolean mightFail = new AtomicBoolean();
            ExternalSet set = Type.cast(left.elements, right.elements, (AtomicBoolean)mightFail);
            if (left.elements.equals((Object)set) && !mightFail.get()) {
                return SemanticDomain.Satisfiability.SATISFIED;
            }
            return SemanticDomain.Satisfiability.UNKNOWN;
        }
        return SemanticDomain.Satisfiability.UNKNOWN;
    }

    static boolean typeTokensIntersect(ExternalSet<Type> lfiltered, ExternalSet<Type> rfiltered) {
        for (Type l : lfiltered) {
            for (Type r : rfiltered) {
                if (!l.asTypeTokenType().getTypes().intersects(r.asTypeTokenType().getTypes())) continue;
                return true;
            }
        }
        return false;
    }

    protected InferredTypes lubAux(InferredTypes other) throws SemanticException {
        return new InferredTypes((ExternalSet<Type>)this.elements.union(other.elements));
    }

    protected InferredTypes wideningAux(InferredTypes other) throws SemanticException {
        return this.lubAux(other);
    }

    protected boolean lessOrEqualAux(InferredTypes other) throws SemanticException {
        return other.elements.contains(this.elements);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        InferredTypes other = (InferredTypes)((Object)obj);
        return !(this.elements == null ? other.elements != null : !this.elements.equals(other.elements));
    }

    protected InferredValue.InferredPair<InferredTypes> evalTypeCast(BinaryExpression cast, InferredTypes left, InferredTypes right, InferredTypes state, ProgramPoint pp) {
        ExternalSet inferred = cast.getOperator().typeInference(left.elements, right.elements);
        if (inferred.isEmpty()) {
            return BOTTOM_PAIR;
        }
        return this.mk(new InferredTypes((ExternalSet<Type>)inferred));
    }

    protected InferredValue.InferredPair<InferredTypes> evalTypeConv(BinaryExpression conv, InferredTypes left, InferredTypes right, InferredTypes state, ProgramPoint pp) {
        ExternalSet inferred = conv.getOperator().typeInference(left.elements, right.elements);
        if (inferred.isEmpty()) {
            return BOTTOM_PAIR;
        }
        return this.mk(new InferredTypes((ExternalSet<Type>)inferred));
    }

    public boolean tracksIdentifiers(Identifier id) {
        return !(id instanceof MemoryPointer);
    }

    public boolean canProcess(SymbolicExpression expression) {
        return true;
    }
}

