/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.interprocedural;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.CFGWithAnalysisResults;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.lattices.FunctionalLattice;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.interprocedural.ContextSensitivityToken;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class CFGResults<A extends AbstractState<A, H, V>, H extends HeapDomain<H>, V extends ValueDomain<V>>
extends FunctionalLattice<CFGResults<A, H, V>, ContextSensitivityToken, CFGWithAnalysisResults<A, H, V>> {
    public CFGResults(CFGWithAnalysisResults<A, H, V> lattice) {
        super(lattice);
    }

    private CFGResults(CFGWithAnalysisResults<A, H, V> lattice, Map<ContextSensitivityToken, CFGWithAnalysisResults<A, H, V>> function) {
        super(lattice, function);
    }

    public Pair<Boolean, CFGWithAnalysisResults<A, H, V>> putResult(ContextSensitivityToken token, CFGWithAnalysisResults<A, H, V> result) throws SemanticException {
        CFGWithAnalysisResults previousResult = (CFGWithAnalysisResults)this.function.get(token);
        if (previousResult == null) {
            this.function.put(token, result);
            return Pair.of((Object)false, result);
        }
        if (previousResult.lessOrEqual(result)) {
            if (result.lessOrEqual(previousResult)) {
                return Pair.of((Object)false, (Object)previousResult);
            }
            this.function.put(token, result);
            return Pair.of((Object)true, result);
        }
        if (result.lessOrEqual(previousResult)) {
            return Pair.of((Object)false, (Object)previousResult);
        }
        CFGWithAnalysisResults lub = previousResult.lub(result);
        this.function.put(token, lub);
        return Pair.of((Object)true, (Object)lub);
    }

    public boolean contains(ContextSensitivityToken token) {
        return this.function != null && this.function.containsKey(token);
    }

    public Collection<CFGWithAnalysisResults<A, H, V>> getAll() {
        return this.function.values();
    }

    public CFGResults<A, H, V> top() {
        return new CFGResults<A, H, V>(((CFGWithAnalysisResults)this.lattice).top());
    }

    public boolean isTop() {
        return ((CFGWithAnalysisResults)this.lattice).isTop() && (this.function == null || this.function.isEmpty());
    }

    public CFGResults<A, H, V> bottom() {
        return new CFGResults<A, H, V>(((CFGWithAnalysisResults)this.lattice).bottom());
    }

    public boolean isBottom() {
        return ((CFGWithAnalysisResults)this.lattice).isBottom() && (this.function == null || this.function.isEmpty());
    }

    protected CFGResults<A, H, V> mk(CFGWithAnalysisResults<A, H, V> lattice, Map<ContextSensitivityToken, CFGWithAnalysisResults<A, H, V>> function) {
        return new CFGResults<A, H, V>(lattice, function);
    }
}

