/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.interprocedural;

import it.unive.lisa.AnalysisExecutionException;
import it.unive.lisa.AnalysisSetupException;
import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.CFGWithAnalysisResults;
import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.caches.Caches;
import it.unive.lisa.interprocedural.CFGResults;
import it.unive.lisa.interprocedural.CallGraphBasedAnalysis;
import it.unive.lisa.interprocedural.ContextSensitivityToken;
import it.unive.lisa.interprocedural.FixpointResults;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.interprocedural.SingleScopeToken;
import it.unive.lisa.logging.IterationLogger;
import it.unive.lisa.logging.TimerLogger;
import it.unive.lisa.program.CodeElement;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeMember;
import it.unive.lisa.program.cfg.Parameter;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.program.cfg.statement.call.CFGCall;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.Variable;
import it.unive.lisa.util.collections.workset.FIFOWorkingSet;
import it.unive.lisa.util.collections.workset.VisitOnceWorkingSet;
import it.unive.lisa.util.collections.workset.WorkingSet;
import it.unive.lisa.util.datastructures.graph.algorithms.FixpointException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContextBasedAnalysis<A extends AbstractState<A, H, V>, H extends HeapDomain<H>, V extends ValueDomain<V>>
extends CallGraphBasedAnalysis<A, H, V> {
    private static final Logger LOG = LogManager.getLogger(ContextBasedAnalysis.class);
    private FixpointResults<A, H, V> results;
    private ContextSensitivityToken token;
    private final Collection<CFG> fixpointTriggers;
    private Class<? extends WorkingSet<Statement>> fixpointWorkingSet;
    private int wideningThreshold;

    public ContextBasedAnalysis() {
        this(SingleScopeToken.getSingleton());
    }

    public ContextBasedAnalysis(ContextSensitivityToken token) {
        this.token = token.empty();
        this.fixpointTriggers = new HashSet<CFG>();
    }

    public void fixpoint(AnalysisState<A, H, V> entryState, Class<? extends WorkingSet<Statement>> fixpointWorkingSet, int wideningThreshold) throws FixpointException {
        this.results = null;
        this.fixpointWorkingSet = fixpointWorkingSet;
        this.wideningThreshold = wideningThreshold;
        if (this.program.getEntryPoints().isEmpty()) {
            throw new FixpointException("The program contains no entrypoints");
        }
        TimerLogger.execAction((Logger)LOG, (String)"Computing fixpoint over the whole program", () -> this.fixpointAux(entryState, fixpointWorkingSet, wideningThreshold));
    }

    private static String ordinal(int i) {
        int n = i % 100;
        if (n == 11 || n == 12 || n == 13 || n % 10 == 0 || n % 10 > 3) {
            return i + "th";
        }
        if (n % 10 == 1) {
            return i + "st";
        }
        if (n % 10 == 2) {
            return i + "nd";
        }
        return i + "rd";
    }

    private void fixpointAux(AnalysisState<A, H, V> entryState, Class<? extends WorkingSet<Statement>> fixpointWorkingSet, int wideningThreshold) throws AnalysisExecutionException {
        int iter = 0;
        do {
            LOG.info("Performing %s fixpoint iteration", (Object)ContextBasedAnalysis.ordinal(iter + 1));
            this.fixpointTriggers.clear();
            for (CFG cfg2 : IterationLogger.iterate((Logger)LOG, (Collection)this.program.getEntryPoints(), (String)"Processing entrypoints", (String)"entries")) {
                try {
                    CFGResults value = new CFGResults(new CFGWithAnalysisResults(cfg2, entryState));
                    AnalysisState<A, H, V> entryStateCFG = this.prepareEntryStateOfEntryPoint(entryState, cfg2);
                    if (this.results == null) {
                        this.results = new FixpointResults(value.top());
                    }
                    this.results.putResult(cfg2, this.token.empty(), cfg2.fixpoint(entryStateCFG, (InterproceduralAnalysis)this, WorkingSet.of(fixpointWorkingSet), wideningThreshold));
                }
                catch (AnalysisSetupException | SemanticException e) {
                    throw new AnalysisExecutionException("Error while creating the entrystate for " + cfg2, e);
                }
                catch (FixpointException e) {
                    throw new AnalysisExecutionException("Error while computing fixpoint for entrypoint " + cfg2, (Throwable)e);
                }
            }
            VisitOnceWorkingSet ws = VisitOnceWorkingSet.mk((WorkingSet)FIFOWorkingSet.mk());
            this.fixpointTriggers.forEach(cfg -> this.callgraph.getCallers((CodeMember)cfg).stream().filter(CFG.class::isInstance).map(CFG.class::cast).forEach(arg_0 -> ((VisitOnceWorkingSet)ws).push(arg_0)));
            while (!ws.isEmpty()) {
                this.callgraph.getCallers((CodeMember)ws.pop()).stream().filter(CFG.class::isInstance).map(CFG.class::cast).forEach(arg_0 -> ((VisitOnceWorkingSet)ws).push(arg_0));
            }
            ws.getSeen().forEach(this.results::forget);
            ++iter;
        } while (!this.fixpointTriggers.isEmpty());
    }

    public Collection<CFGWithAnalysisResults<A, H, V>> getAnalysisResultsOf(CFG cfg) {
        if (this.results.contains(cfg)) {
            return ((CFGResults)this.results.getState(cfg)).getAll();
        }
        return Collections.emptySet();
    }

    private Pair<AnalysisState<A, H, V>, AnalysisState<A, H, V>> getEntryAndExit(CFG cfg) throws SemanticException {
        if (!this.results.contains(cfg)) {
            return null;
        }
        CFGResults cfgresult = (CFGResults)this.results.getState(cfg);
        if (!cfgresult.contains(this.token)) {
            return null;
        }
        CFGWithAnalysisResults analysisresult = (CFGWithAnalysisResults)cfgresult.getState(this.token);
        return Pair.of((Object)analysisresult.getEntryState(), (Object)analysisresult.getExitState());
    }

    public AnalysisState<A, H, V> getAbstractResultOf(CFGCall call, AnalysisState<A, H, V> entryState, ExpressionSet<SymbolicExpression>[] parameters) throws SemanticException {
        ScopeToken scope = new ScopeToken((CodeElement)call);
        this.token = this.token.pushToken(scope);
        AnalysisState result = entryState.bottom();
        for (CFG cfg : call.getTargets()) {
            AnalysisState exitState;
            AnalysisState callState;
            Pair<AnalysisState<A, H, V>, AnalysisState<A, H, V>> states = this.getEntryAndExit(cfg);
            AnalysisState prepared = callState = entryState.pushScope(scope);
            for (int i = 0; i < parameters.length; ++i) {
                AnalysisState temp = prepared.bottom();
                Parameter parameter = cfg.getDescriptor().getArgs()[i];
                Variable parid = new Variable(Caches.types().mkSet((Iterable)parameter.getStaticType().allInstances()), parameter.getName(), parameter.getAnnotations(), parameter.getLocation());
                for (SymbolicExpression exp : parameters[i]) {
                    temp = (AnalysisState)temp.lub((BaseLattice)prepared.assign((Identifier)parid, exp.pushScope(scope), cfg.getGenericProgramPoint()));
                }
                prepared = temp;
            }
            if (states != null && prepared.lessOrEqual((BaseLattice)((AnalysisState)states.getLeft()))) {
                exitState = (AnalysisState)states.getRight();
            } else {
                CFGWithAnalysisResults<A, H, V> fixpointResult = null;
                try {
                    fixpointResult = this.computeFixpoint(cfg, this.token, prepared);
                }
                catch (AnalysisSetupException | FixpointException e) {
                    throw new SemanticException("Exception during the interprocedural analysis", e);
                }
                exitState = fixpointResult.getExitState();
            }
            AnalysisState tmp = callState.bottom();
            Identifier meta = (Identifier)call.getMetaVariable().pushScope(scope);
            for (SymbolicExpression ret : exitState.getComputedExpressions()) {
                tmp = (AnalysisState)tmp.lub((BaseLattice)exitState.assign(meta, ret, (ProgramPoint)call));
            }
            result = (AnalysisState)result.lub((BaseLattice)tmp.popScope(scope));
        }
        this.token = this.token.popToken();
        this.callgraph.registerCall(call);
        return result;
    }

    private CFGWithAnalysisResults<A, H, V> computeFixpoint(CFG cfg, ContextSensitivityToken localToken, AnalysisState<A, H, V> computedEntryState) throws FixpointException, SemanticException, AnalysisSetupException {
        CFGWithAnalysisResults fixpointResult = cfg.fixpoint(computedEntryState, (InterproceduralAnalysis)this, WorkingSet.of(this.fixpointWorkingSet), this.wideningThreshold);
        fixpointResult.setId(localToken.toString());
        Pair<Boolean, CFGWithAnalysisResults<A, H, V>> res = this.results.putResult(cfg, localToken, fixpointResult);
        if (Boolean.TRUE.equals(res.getLeft())) {
            this.fixpointTriggers.add(cfg);
        }
        return (CFGWithAnalysisResults)res.getRight();
    }
}

