/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.interprocedural;

import it.unive.lisa.AnalysisSetupException;
import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.CFGWithAnalysisResults;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.caches.Caches;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.interprocedural.InterproceduralAnalysisException;
import it.unive.lisa.interprocedural.OpenCallPolicy;
import it.unive.lisa.interprocedural.callgraph.CallGraph;
import it.unive.lisa.interprocedural.callgraph.CallResolutionException;
import it.unive.lisa.logging.IterationLogger;
import it.unive.lisa.program.Program;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.Parameter;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.program.cfg.statement.call.CFGCall;
import it.unive.lisa.program.cfg.statement.call.Call;
import it.unive.lisa.program.cfg.statement.call.OpenCall;
import it.unive.lisa.program.cfg.statement.call.UnresolvedCall;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.PushAny;
import it.unive.lisa.symbolic.value.Variable;
import it.unive.lisa.util.collections.externalSet.ExternalSet;
import it.unive.lisa.util.collections.workset.WorkingSet;
import it.unive.lisa.util.datastructures.graph.algorithms.FixpointException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModularWorstCaseAnalysis<A extends AbstractState<A, H, V>, H extends HeapDomain<H>, V extends ValueDomain<V>>
implements InterproceduralAnalysis<A, H, V> {
    private static final Logger LOG = LogManager.getLogger(ModularWorstCaseAnalysis.class);
    private Program program;
    private OpenCallPolicy policy;
    private final Map<CFG, Optional<CFGWithAnalysisResults<A, H, V>>> results = new ConcurrentHashMap<CFG, Optional<CFGWithAnalysisResults<A, H, V>>>();

    public void fixpoint(AnalysisState<A, H, V> entryState, Class<? extends WorkingSet<Statement>> fixpointWorkingSet, int wideningThreshold) throws FixpointException {
        for (CFG cfg : IterationLogger.iterate((Logger)LOG, (Collection)this.program.getAllCFGs(), (String)"Computing fixpoint over the whole program", (String)"cfgs")) {
            try {
                AnalysisState prepared = entryState;
                for (Parameter arg : cfg.getDescriptor().getArgs()) {
                    ExternalSet all = Caches.types().mkSet((Iterable)arg.getStaticType().allInstances());
                    Variable id = new Variable(all, arg.getName(), arg.getAnnotations(), arg.getLocation());
                    prepared = prepared.assign((Identifier)id, (SymbolicExpression)new PushAny(all, arg.getLocation()), cfg.getGenericProgramPoint());
                }
                this.results.put(cfg, Optional.of(cfg.fixpoint(prepared, (InterproceduralAnalysis)this, WorkingSet.of(fixpointWorkingSet), wideningThreshold)));
            }
            catch (AnalysisSetupException | SemanticException e) {
                throw new FixpointException("Error while creating the entrystate for " + cfg, e);
            }
        }
    }

    public Collection<CFGWithAnalysisResults<A, H, V>> getAnalysisResultsOf(CFG cfg) {
        return Collections.singleton(this.results.get(cfg).orElse(null));
    }

    public AnalysisState<A, H, V> getAbstractResultOf(CFGCall call, AnalysisState<A, H, V> entryState, ExpressionSet<SymbolicExpression>[] parameters) throws SemanticException {
        OpenCall open = new OpenCall(call.getCFG(), call.getLocation(), call.getTargetName(), call.getStaticType(), call.getParameters());
        return this.getAbstractResultOf(open, entryState, parameters);
    }

    public AnalysisState<A, H, V> getAbstractResultOf(OpenCall call, AnalysisState<A, H, V> entryState, ExpressionSet<SymbolicExpression>[] parameters) throws SemanticException {
        return this.policy.apply(call, entryState, parameters);
    }

    public void init(Program program, CallGraph callgraph, OpenCallPolicy policy) throws InterproceduralAnalysisException {
        this.program = program;
        this.policy = policy;
    }

    public Call resolve(UnresolvedCall unresolvedCall) throws CallResolutionException {
        OpenCall open = new OpenCall(unresolvedCall.getCFG(), unresolvedCall.getLocation(), unresolvedCall.getTargetName(), unresolvedCall.getStaticType(), unresolvedCall.getParameters());
        open.setRuntimeTypes(unresolvedCall.getRuntimeTypes());
        return open;
    }
}

