/*
 * Decompiled with CFR 0.152.
 */
package ushiosan.jvm_utilities.error;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import org.jetbrains.annotations.NotNull;
import ushiosan.jvm_utilities.lang.Cls;
import ushiosan.jvm_utilities.lang.Obj;

public final class Errors {
    private Errors() {
    }

    public static <T extends Throwable> void launch(@NotNull Class<T> clazz, Object ... args) throws T {
        Throwable errorInstance;
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(Cls.toTypeArgs(args));
            errorInstance = (Throwable)Obj.cast(constructor.newInstance(args), clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw errorInstance;
    }

    @NotNull
    public static Throwable getRootCause(@NotNull Throwable base) {
        Throwable parent;
        Throwable result = base;
        while ((parent = result.getCause()) != null) {
            result = parent;
        }
        return result;
    }

    @NotNull
    public static String toString(@NotNull Throwable error, boolean simplify) {
        Throwable realError = simplify ? Errors.getRootCause(error) : error;
        StringWriter writer = new StringWriter();
        PrintWriter printer = new PrintWriter(writer);
        realError.printStackTrace(printer);
        printer.flush();
        return writer.toString();
    }
}

