/*
 * Decompiled with CFR 0.152.
 */
package ushiosan.jvm_utilities.function.predicate;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import ushiosan.jvm_utilities.lang.collection.Arrs;
import ushiosan.jvm_utilities.lang.io.IO;

public interface ExtensionPredicate<T extends Path>
extends Predicate<T> {
    @NotNull
    public static <T extends Path> Predicate<T> of(final boolean acceptDirs, final String ... extensions) {
        return new ExtensionPredicate<T>(){

            @Override
            public boolean accepDirectoryObjects() {
                return acceptDirs;
            }

            @Override
            public String @NotNull [] getExtensions() {
                return extensions;
            }
        };
    }

    @NotNull
    public static <T extends Path> Predicate<T> of(String ... extensions) {
        return ExtensionPredicate.of(true, extensions);
    }

    public String @NotNull [] getExtensions();

    default public boolean accepDirectoryObjects() {
        return true;
    }

    @Override
    default public boolean test(@NotNull T path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            return this.accepDirectoryObjects();
        }
        Object[] extensions = this.getExtensions();
        Optional<String> extension = IO.getExtension(path);
        if (extension.isEmpty()) {
            return false;
        }
        return Arrs.contains(extensions, extension);
    }
}

