/*
 * Decompiled with CFR 0.152.
 */
package ushiosan.jvm_utilities.function.predicate;

import java.nio.file.Path;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;

public interface RegexPredicate<T extends Path>
extends Predicate<T> {
    @NotNull
    public static <T extends Path> Predicate<T> of(final boolean fullPath, @NotNull @RegExp String regex) {
        final Pattern pattern = Pattern.compile(regex);
        return new RegexPredicate<T>(){

            @Override
            public boolean isFullPathInspect() {
                return fullPath;
            }

            @Override
            public Pattern getPattern() {
                return pattern;
            }
        };
    }

    @NotNull
    public static <T extends Path> Predicate<T> of(@NotNull @RegExp String regex) {
        return RegexPredicate.of(true, regex);
    }

    public Pattern getPattern();

    default public boolean isFullPathInspect() {
        return true;
    }

    @Override
    default public boolean test(@NotNull T path) {
        Object realPath = this.isFullPathInspect() ? path : path.getFileName();
        Matcher matcher = this.getPattern().matcher(realPath.toString());
        return matcher.find();
    }
}

