/*
 * Decompiled with CFR 0.152.
 */
package ushiosan.jvm_utilities.internal.collection;

import java.util.Arrays;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import ushiosan.jvm_utilities.lang.Obj;

public final class ArrsImpl {
    private ArrsImpl() {
    }

    public static Number @NotNull [] toNumberArray(@NotNull Object array) {
        Class<?> refClass = array.getClass();
        if (!refClass.isArray()) {
            throw new IllegalArgumentException("Invalid array type.");
        }
        if (refClass == byte[].class) {
            return ArrsImpl.toNumberArrayFromPrimitive(Obj.cast(array, byte[].class));
        }
        if (refClass == short[].class) {
            return ArrsImpl.toNumberArrayFromPrimitive(Obj.cast(array, short[].class));
        }
        if (refClass == int[].class) {
            return ArrsImpl.toNumberArrayFromPrimitive(Obj.cast(array, int[].class));
        }
        if (refClass == long[].class) {
            return ArrsImpl.toNumberArrayFromPrimitive(Obj.cast(array, long[].class));
        }
        if (refClass == float[].class) {
            return ArrsImpl.toNumberArrayFromPrimitive(Obj.cast(array, float[].class));
        }
        if (refClass == double[].class) {
            return ArrsImpl.toNumberArrayFromPrimitive(Obj.cast(array, double[].class));
        }
        throw new IllegalArgumentException("Invalid numeric array.");
    }

    public static Object @NotNull [] toObjectArray(@NotNull Object array) {
        Class<?> refClass = array.getClass();
        if (!refClass.isArray()) {
            throw new IllegalArgumentException("Invalid array type.");
        }
        if (refClass == boolean[].class) {
            return ArrsImpl.toObjectArrayImpl(Obj.cast(array, boolean[].class));
        }
        if (refClass == char[].class) {
            return ArrsImpl.toObjectArrayImpl(Obj.cast(array, char[].class));
        }
        if (refClass == byte[].class || refClass == short[].class || refClass == int[].class || refClass == long[].class || refClass == float[].class || refClass == double[].class) {
            return ArrsImpl.toNumberArray(array);
        }
        return (Object[])Obj.cast(array);
    }

    @Contract(pure=true)
    private static Boolean @NotNull [] toObjectArrayImpl(boolean @NotNull [] array) {
        int total = array.length;
        Boolean[] result = new Boolean[total];
        for (int i = 0; i < total; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    @Contract(pure=true)
    private static Character @NotNull [] toObjectArrayImpl(char @NotNull [] array) {
        int total = array.length;
        Character[] result = new Character[total];
        for (int i = 0; i < total; ++i) {
            result[i] = Character.valueOf(array[i]);
        }
        return result;
    }

    @Contract(pure=true)
    private static Number @NotNull [] toNumberArrayFromPrimitive(byte @NotNull [] array) {
        int total = array.length;
        Number[] result = new Number[total];
        for (int i = 0; i < total; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    @Contract(pure=true)
    private static Number @NotNull [] toNumberArrayFromPrimitive(short @NotNull [] array) {
        int total = array.length;
        Number[] result = new Number[total];
        for (int i = 0; i < total; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    @Contract(pure=true)
    private static Number @NotNull [] toNumberArrayFromPrimitive(int @NotNull [] array) {
        return (Number[])Arrays.stream(array).boxed().toArray(Number[]::new);
    }

    @Contract(pure=true)
    private static Number @NotNull [] toNumberArrayFromPrimitive(long @NotNull [] array) {
        return (Number[])Arrays.stream(array).boxed().toArray(Number[]::new);
    }

    @Contract(pure=true)
    private static Number @NotNull [] toNumberArrayFromPrimitive(float @NotNull [] array) {
        int total = array.length;
        Number[] result = new Number[total];
        for (int i = 0; i < total; ++i) {
            result[i] = Float.valueOf(array[i]);
        }
        return result;
    }

    @Contract(pure=true)
    private static Number @NotNull [] toNumberArrayFromPrimitive(double @NotNull [] array) {
        return (Number[])Arrays.stream(array).boxed().toArray(Number[]::new);
    }
}

