/*
 * Decompiled with CFR 0.152.
 */
package ushiosan.jvm_utilities.internal.io;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import ushiosan.jvm_utilities.lang.collection.Collections;

public abstract class IOImpl {
    public static final String FILESYSTEM_ROOT = "/";

    protected IOImpl() {
    }

    @NotNull
    protected static FileSystem getValidFilesystem(@NotNull URL url) throws IOException {
        try {
            return IOImpl.getValidFilesystem(url.toURI());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @NotNull
    protected static FileSystem getValidFilesystem(@NotNull URI uri) throws IOException {
        switch (uri.getScheme()) {
            case "file": {
                return Path.of(uri).getFileSystem();
            }
            case "jar": {
                return FileSystems.newFileSystem(uri, Collections.mapOf());
            }
        }
        throw new IOException(String.format("Scheme \"%s\" is not supported.", uri.getScheme()));
    }

    @NotNull
    protected static Path getValidPath(@NotNull URL url) throws IOException {
        try {
            return IOImpl.getValidPath(url.toURI());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @NotNull
    protected static Path getValidPath(@NotNull URI uri) throws IOException {
        switch (uri.getScheme()) {
            case "file": {
                return Path.of(uri);
            }
            case "jar": {
                FileSystem fileSystem = IOImpl.getValidFilesystem(uri);
                return fileSystem.getPath(FILESYSTEM_ROOT, new String[0]);
            }
        }
        throw new IOException(String.format("Scheme \"%s\" is not supported.", uri.getScheme()));
    }
}

