/*
 * Decompiled with CFR 0.152.
 */
package ushiosan.jvm_utilities.internal.print.instance;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import ushiosan.jvm_utilities.lang.Obj;
import ushiosan.jvm_utilities.lang.collection.Arrs;
import ushiosan.jvm_utilities.lang.collection.elements.Pair;
import ushiosan.jvm_utilities.lang.print.annotations.PrintExclude;
import ushiosan.jvm_utilities.lang.print.annotations.PrintOpts;

public final class PrintInstance {
    private static final String[] INVALID_METHODS = new String[]{"toString", "getClass", "hashCode", "getDeclaringClass", "ordinal"};
    private static final Method[] EMPTY_METHODS = new Method[0];
    private static final Field[] EMPTY_FIELDS = new Field[0];
    private static final PrintOpts DEFAULT_OPTS = new PrintOpts(){

        @Override
        public boolean shortName() {
            return true;
        }

        @Override
        public boolean privateFieldsAccess() {
            return false;
        }

        @Override
        public boolean getterAccess() {
            return false;
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public String getterPrefix() {
            return "^(get|is)";
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public String getterSuffix() {
            return "";
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return PrintOpts.class;
        }
    };
    private static PrintInstance INSTANCE;

    private PrintInstance() {
    }

    public static PrintInstance getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PrintInstance();
        }
        return INSTANCE;
    }

    @NotNull
    public String toString(@NotNull Object obj) {
        PrintOpts opts = DEFAULT_OPTS;
        Class<?> objClass = obj.getClass();
        if (objClass.isAnnotationPresent(PrintOpts.class)) {
            opts = objClass.getAnnotation(PrintOpts.class);
        }
        return this.toStringImpl(obj, opts);
    }

    @NotNull
    private String toStringImpl(@NotNull Object obj, @NotNull PrintOpts opts) {
        int i2;
        Class<?> clazz = obj.getClass();
        Method[] methods = this.getAllValidMethods(clazz, opts);
        Field[] fields = this.getAllValidFields(clazz, opts);
        StringBuilder builder = new StringBuilder(opts.shortName() ? clazz.getSimpleName() : Obj.toString(clazz));
        builder.append("{");
        try {
            for (i2 = 0; i2 < fields.length; ++i2) {
                fields[i2].setAccessible(true);
                if (i2 != 0) {
                    builder.append(", ");
                }
                builder.append(fields[i2].getName()).append("=");
                builder.append(Obj.toString(fields[i2].get(obj)));
            }
        }
        catch (Exception i2) {
            // empty catch block
        }
        try {
            if (!builder.toString().endsWith("{") && methods.length != 0) {
                builder.append(", ");
            }
            for (i2 = 0; i2 < methods.length; ++i2) {
                methods[i2].setAccessible(true);
                if (i2 != 0) {
                    builder.append(", ");
                }
                builder.append(methods[i2].getName()).append("()=");
                builder.append(Obj.toString(methods[i2].invoke(obj, new Object[0])));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return builder.append("}").toString();
    }

    private Field @NotNull [] getAllValidFields(@NotNull Class<?> cls, @NotNull PrintOpts opts) {
        if (cls.getDeclaredFields().length == 0) {
            return EMPTY_FIELDS;
        }
        return (Field[])Arrays.stream(cls.getFields()).map(it -> Pair.of(it, opts)).filter(this::isValidField).map(it -> (Field)it.first).toArray(Field[]::new);
    }

    private Method @NotNull [] getAllValidMethods(@NotNull Class<?> cls, @NotNull PrintOpts opts) {
        Pattern prefix = Pattern.compile(opts.getterPrefix());
        Pattern suffix = Pattern.compile(opts.getterSuffix());
        if (!opts.getterAccess()) {
            return EMPTY_METHODS;
        }
        return (Method[])Arrays.stream(cls.getMethods()).map(it -> Pair.of(it, Pair.of(prefix, suffix))).filter(this::isValidMethod).map(it -> (Method)it.first).toArray(Method[]::new);
    }

    private boolean isValidField(@NotNull Pair<Field, PrintOpts> pair) {
        boolean modsState;
        int mods = ((Field)pair.first).getModifiers();
        boolean bl = modsState = !Modifier.isAbstract(mods) && !Modifier.isStatic(mods);
        if (((PrintOpts)pair.second).privateFieldsAccess()) {
            modsState = modsState && !Modifier.isPrivate(mods) && !Modifier.isProtected(mods);
        }
        return modsState && !((Field)pair.first).isAnnotationPresent(PrintExclude.class);
    }

    private boolean isValidMethod(@NotNull Pair<Method, Pair<Pattern, Pattern>> pair) {
        Method method = (Method)pair.first;
        if (method.getParameterCount() != 0 || method.getReturnType() == Void.TYPE) {
            return false;
        }
        Matcher pMatch = ((Pattern)((Pair)pair.second).first).matcher(method.getName());
        Matcher sMatch = ((Pattern)((Pair)pair.second).second).matcher(method.getName());
        if (!pMatch.find() || !sMatch.find() || Arrs.contains(INVALID_METHODS, method.getName())) {
            return false;
        }
        int mods = method.getModifiers();
        boolean modsState = !Modifier.isAbstract(mods) && !Modifier.isPrivate(mods) && !Modifier.isProtected(mods) && !Modifier.isStatic(mods);
        return modsState && !method.isAnnotationPresent(PrintExclude.class);
    }
}

