/*
 * Decompiled with CFR 0.152.
 */
package ushiosan.jvm_utilities.internal.print.str;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ushiosan.jvm_utilities.function.Apply;
import ushiosan.jvm_utilities.internal.print.str.BasePrintArray;
import ushiosan.jvm_utilities.internal.print.str.SimplePrintObject;
import ushiosan.jvm_utilities.internal.print.str.VerbosePrintObject;
import ushiosan.jvm_utilities.lang.Cls;
import ushiosan.jvm_utilities.lang.Obj;
import ushiosan.jvm_utilities.lang.collection.Collections;
import ushiosan.jvm_utilities.lang.collection.elements.Pair;

public abstract class BasePrintObject {
    protected List<Pair<Apply.Result<Object, String>, Class<?>[]>> printMap = Collections.mutableListOf(new Pair[0]);

    protected BasePrintObject() {
        this.attach(this::toClassString, Class.class);
        this.attach(this::toCollectionString, Collection.class);
        this.attach(this::toEntryString, Map.Entry.class);
        this.attach(this::toMapString, Map.class);
        this.attach(this::toStringString, String.class, CharSequence.class);
        this.attach(this::toObjectString, Object.class);
    }

    @NotNull
    public static BasePrintObject getInstance(boolean verbose) {
        return verbose ? VerbosePrintObject.getInstance() : SimplePrintObject.getInstance();
    }

    @NotNull
    public String nullString() {
        return "<null>";
    }

    protected String toStringString(@NotNull Object obj) {
        return String.format("\"%s\"", obj);
    }

    @NotNull
    protected String toEntryString(@NotNull Object obj) {
        Map.Entry entry = Obj.cast(obj, Map.Entry.class);
        return String.format("%s=%s", this.toString(entry.getKey()), this.toString(entry.getValue()));
    }

    @NotNull
    protected String toObjectString(@NotNull Object obj) {
        Class<?> clazz = obj.getClass();
        boolean toStringExists = Arrays.stream(clazz.getDeclaredMethods()).anyMatch(it -> it.getName().equals("toString"));
        return toStringExists ? obj.toString() : String.format("(@%X) %s", obj.hashCode(), BasePrintObject.getInstance(true).toClassString(clazz));
    }

    @NotNull
    protected String toClassString(@NotNull Object obj) {
        Class clazz = Obj.cast(obj, Class.class);
        String name = "";
        if (clazz.isPrimitive() || clazz.isArray()) {
            name = clazz.getCanonicalName();
        }
        if (name.isBlank()) {
            name = clazz.getName();
        }
        return name;
    }

    public void attachExtension(@NotNull Pair<Apply.Result<Object, String>, Class<?>[]> extension) {
        int lastIndex = this.printMap.size() - 1;
        Pair<Apply.Result<Object, String>, Class<?>[]> lastElement = this.printMap.get(lastIndex);
        List<Pair<Apply.Result<Object, String>, Class<?>[]>> tmpList = Collections.mutableListOf(this.printMap.subList(0, lastIndex));
        tmpList.add(extension);
        tmpList.add(lastElement);
        this.printMap = tmpList;
    }

    public void attachExtension(@NotNull Apply.Result<Object, String> action, Class<?> ... supported) {
        this.attachExtension(Pair.of(action, supported));
    }

    @NotNull
    public String toString(@Nullable Object obj) {
        if (obj == null) {
            return this.nullString();
        }
        if (Cls.isPrimitive(obj)) {
            return Obj.canCast(obj, Character.class) ? String.format("'%s'", obj) : obj.toString();
        }
        if (obj.getClass().isArray()) {
            return BasePrintArray.getInstance(this).toString(obj);
        }
        String result = this.nullString();
        for (Pair<Apply.Result<Object, String>, Class<?>[]> entry : this.printMap) {
            Class[] entryClassArr;
            for (Class clazz : entryClassArr = (Class[])entry.second) {
                if (!Obj.canCastNotNull(obj, clazz)) continue;
                return (String)((Apply.Result)entry.first).apply(obj);
            }
        }
        return result;
    }

    @NotNull
    protected abstract String toCollectionString(@NotNull Object var1);

    @NotNull
    protected abstract String toMapString(@NotNull Object var1);

    private void attach(@NotNull Apply.Result<Object, String> action, Class<?> ... supported) {
        this.printMap.add(Pair.of(action, supported));
    }
}

