/*
 * Decompiled with CFR 0.152.
 */
package ushiosan.jvm_utilities.internal.print.str;

import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import ushiosan.jvm_utilities.internal.print.str.BasePrintObject;
import ushiosan.jvm_utilities.lang.Obj;

public final class VerbosePrintObject
extends BasePrintObject {
    private static BasePrintObject INSTANCE;

    private VerbosePrintObject() {
    }

    static BasePrintObject getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new VerbosePrintObject();
        }
        return INSTANCE;
    }

    @Override
    @NotNull
    protected String toCollectionString(@NotNull Object obj) {
        Collection collection = Obj.cast(obj, Collection.class);
        String clazzStr = this.toClassString(obj.getClass());
        StringBuilder builder = Obj.also(new StringBuilder(clazzStr), it -> it.append(" ["));
        int index = 0;
        int total = collection.size();
        for (Object it2 : collection) {
            builder.append(this.toString(it2));
            if (++index == total) continue;
            builder.append(", ");
        }
        return builder.append("]").toString();
    }

    @Override
    @NotNull
    protected String toMapString(@NotNull Object obj) {
        Map mapObj = Obj.cast(obj, Map.class);
        String clazzStr = this.toClassString(obj.getClass());
        StringBuilder builder = Obj.also(new StringBuilder(clazzStr), it -> it.append(" {"));
        int index = 0;
        int total = mapObj.size();
        for (Map.Entry entry : mapObj.entrySet()) {
            builder.append(this.toString(entry));
            if (++index == total) continue;
            builder.append(", ");
        }
        return builder.append("}").toString();
    }
}

