/*
 * Decompiled with CFR 0.152.
 */
package ushiosan.jvm_utilities.lang;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import ushiosan.jvm_utilities.lang.collection.Arrs;

public final class Cls {
    private static final Class<?>[] PRIMITIVE_WRAPPED_CLASSES = new Class[]{Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Void.class};
    private static final Class<?>[] PRIMITIVE_ARRAY_CLASSES = new Class[]{boolean[].class, char[].class, byte[].class, short[].class, int[].class, long[].class, float[].class, double[].class};

    private Cls() {
    }

    public static boolean isPrimitive(@NotNull Class<?> clazz) {
        return clazz.isPrimitive() || Arrs.contains(PRIMITIVE_WRAPPED_CLASSES, clazz);
    }

    public static boolean isPrimitive(@NotNull Object obj) {
        return Cls.isPrimitive(obj.getClass());
    }

    public static boolean isPrimitiveArray(@NotNull Class<?> clazz) {
        return clazz.isArray() && Arrs.contains(PRIMITIVE_ARRAY_CLASSES, clazz);
    }

    public static boolean isPrimitiveArray(@NotNull Object obj) {
        return Cls.isPrimitiveArray(obj.getClass());
    }

    public static Class<?> @NotNull [] toTypeArgs(Object ... args) {
        return (Class[])Arrays.stream(args).map(Object::getClass).toArray(Class[]::new);
    }
}

