/*
 * Decompiled with CFR 0.152.
 */
package ushiosan.jvm_utilities.lang;

public final class Maths {
    public static final double DECIMAL_TOLERANCE = 1.0E-6;
    private static final double RADIANS_DEGREE = 57.29577951308232;
    private static final double DEGREE_RADIANS = Math.PI / 180;

    private Maths() {
    }

    public static double lerp(double base, double objective, double amount) {
        return base + amount * (objective - base);
    }

    public static double lerpPrecise(double base, double objective, double amount) {
        return (1.0 - amount) * base + amount * objective;
    }

    public static double distance(double v1, double v2) {
        return Math.abs(v1 - v2);
    }

    public static double normalize(double start, double end, double current) {
        return (current - start) / (end - start);
    }

    public static double clamp(double value, double min, double max) {
        value = Math.min(value, max);
        value = Math.max(value, min);
        return value;
    }

    public static boolean equals(double v1, double v2, double tolerance) {
        return Maths.distance(v1, v2) <= tolerance;
    }

    public static boolean equals(double v1, double v2) {
        return Maths.equals(v1, v2, 1.0E-6);
    }

    public static boolean isZero(double value, double tolerance) {
        return Math.abs(value) <= tolerance;
    }

    public static boolean isZero(double value) {
        return Maths.isZero(value, 1.0E-6);
    }

    public static double toDegrees(double radians) {
        return radians * 57.29577951308232;
    }

    public static double toRadians(double degrees) {
        return degrees * (Math.PI / 180);
    }

    public static double percentage(double value, double percentage) {
        return value * Maths.percentageValue(percentage);
    }

    public static double percentageValue(double percentage) {
        return percentage / 100.0;
    }
}

