/*
 * Decompiled with CFR 0.152.
 */
package ushiosan.jvm_utilities.lang;

import java.lang.ref.WeakReference;
import java.util.Optional;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ushiosan.jvm_utilities.function.Apply;
import ushiosan.jvm_utilities.lang.collection.elements.Pair;
import ushiosan.jvm_utilities.lang.print.PrintObj;

public final class Obj {
    private Obj() {
    }

    @NotNull
    public static Object toObject(@NotNull Object obj) {
        return obj;
    }

    @NotNull
    public static String toString(@Nullable Object obj) {
        return PrintObj.toString(obj, false);
    }

    @NotNull
    public static String toObjString(@Nullable Object obj) {
        return Obj.toString(obj);
    }

    @NotNull
    public static String toInstanceString(@NotNull Object instance) {
        return PrintObj.toInstanceString(instance);
    }

    @NotNull
    public static String toDetailString(@Nullable Object obj) {
        return PrintObj.toString(obj, true);
    }

    public static boolean isNull(@Nullable Object obj) {
        if (obj == null) {
            return true;
        }
        if (Obj.canCastNotNull(obj, WeakReference.class)) {
            return Obj.cast(obj, WeakReference.class).get() == null;
        }
        if (Obj.canCastNotNull(obj, Optional.class)) {
            return Obj.cast(obj, Optional.class).isEmpty();
        }
        return false;
    }

    public static boolean isNotNull(@Nullable Object obj) {
        return !Obj.isNull(obj);
    }

    @NotNull
    public static <T> T notNull(@Nullable T obj, @NotNull T defaultVal) {
        return Obj.isNull(obj) ? defaultVal : obj;
    }

    public static <T> void notNull(@Nullable T obj, @NotNull Apply.Empty<T> action) {
        if (!Obj.isNull(obj)) {
            action.apply(obj);
        }
    }

    public static <T> T cast(@Nullable Object obj) {
        return (T)obj;
    }

    @Contract(value="_, _ -> param1", pure=true)
    public static <T> T cast(@Nullable Object obj, @NotNull Class<T> clazz) {
        if (obj == null) {
            return Obj.cast(null);
        }
        Class<?> objCls = obj.getClass();
        if (Obj.canCast(obj, clazz)) {
            return Obj.cast(obj);
        }
        throw new ClassCastException("Cannot cast " + objCls.getName() + " to " + clazz.getName());
    }

    public static <T> T pairCast(@NotNull Pair<?, Class<T>> pair) {
        return Obj.cast(pair.first, (Class)pair.second);
    }

    public static <T> void tryCast(@Nullable Object obj, @NotNull Class<T> clazz, Apply.Empty<T> action) {
        if (Obj.canCast(obj, clazz)) {
            action.apply(Obj.cast(obj, clazz));
        }
    }

    public static <T> Optional<T> tryCast(@Nullable Object obj, @NotNull Class<T> clazz) {
        if (Obj.canCast(obj, clazz)) {
            return Optional.ofNullable(Obj.cast(obj, clazz));
        }
        return Optional.empty();
    }

    public static <T> boolean canCast(@Nullable Object obj, @NotNull Class<T> clazz) {
        return Obj.canCastImpl(obj, clazz, true);
    }

    public static <T> boolean canCastNotNull(@Nullable Object obj, @NotNull Class<T> clazz) {
        return Obj.canCastImpl(obj, clazz, false);
    }

    @Contract(value="_, _ -> param1")
    @NotNull
    public static <T> T also(@NotNull T obj, @NotNull Apply.Empty<T> action) {
        action.apply(obj);
        return obj;
    }

    @NotNull
    public static <T, V> V apply(@NotNull T obj, @NotNull Apply.Result<T, V> action) {
        return action.apply(obj);
    }

    private static <T> boolean canCastImpl(@Nullable Object obj, @NotNull Class<T> clazz, boolean nullable) {
        if (obj == null) {
            return nullable;
        }
        Class<T> objCls = obj.getClass();
        return objCls.isAssignableFrom(clazz) || clazz.isInstance(obj);
    }
}

