/*
 * Decompiled with CFR 0.152.
 */
package ushiosan.jvm_utilities.lang;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import ushiosan.jvm_utilities.lang.collection.Arrs;

public final class Strings {
    private static final Pattern SPACES_COUNTER = Pattern.compile("^(\\s+)");

    private Strings() {
    }

    @NotNull
    public static String capitalize(@NotNull CharSequence content, boolean all) {
        String realContent = content.toString();
        String[] chunks = all ? realContent.split("\\s") : Arrs.of(realContent);
        CharSequence[] result = (String[])Arrays.stream(chunks).map(Strings::capitalizeImpl).toArray(String[]::new);
        return String.join((CharSequence)" ", result);
    }

    @NotNull
    public static String capitalize(@NotNull CharSequence content) {
        return Strings.capitalize(content, true);
    }

    @NotNull
    public static String capitalizeWord(@NotNull CharSequence content) {
        return Strings.simpleCapitalize(content);
    }

    @NotNull
    private static String simpleCapitalize(@NotNull CharSequence sequence) {
        String contentStr = sequence.toString().trim();
        if (contentStr.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        char[] wordArr = contentStr.toCharArray();
        builder.append(Character.toUpperCase(wordArr[0]));
        builder.append(contentStr.substring(1));
        return builder.toString();
    }

    @NotNull
    private static String capitalizeImpl(@NotNull CharSequence sequence) {
        if (sequence.toString().isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        String contentStr = sequence.toString();
        Matcher matcher = SPACES_COUNTER.matcher(contentStr);
        int spaces = 0;
        if (matcher.find()) {
            spaces = matcher.group().length();
        }
        builder.append(" ".repeat(spaces));
        builder.append(Strings.simpleCapitalize(contentStr.substring(spaces)));
        return builder.toString();
    }
}

