/*
 * Decompiled with CFR 0.152.
 */
package ushiosan.jvm_utilities.lang.collection;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ushiosan.jvm_utilities.internal.collection.ArrsImpl;
import ushiosan.jvm_utilities.lang.collection.Collections;

public final class Arrs {
    public static final int INDEX_NOT_FOUND = -1;

    private Arrs() {
    }

    @SafeVarargs
    public static <T> T[] of(T ... elements) {
        return elements;
    }

    public static Object @NotNull [] of(Iterator<?> iterator) {
        List<?> iteratorList = Collections.listOf(iterator);
        return iteratorList.toArray();
    }

    @Contract(pure=true)
    public static int indexOf(Object @NotNull [] array, @Nullable Object element) {
        for (int i = 0; i < array.length; ++i) {
            Object it = array[i];
            if (element == null && it == null) {
                return i;
            }
            if (it == null || !it.equals(element)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexOf(Object @NotNull [] array, @Nullable Object element) {
        int maxSize;
        for (int i = maxSize = array.length - 1; i >= 0; --i) {
            Object it = array[i];
            if (element == null && it == null) {
                return i;
            }
            if (it == null || !it.equals(element)) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(Object @NotNull [] array, @Nullable Object element) {
        return Arrs.indexOf(array, element) != -1;
    }

    @NotNull
    public static <T> Optional<T> lastElement(T @NotNull [] array) {
        return Optional.ofNullable(Arrs.unsafeLastElement(array));
    }

    @Nullable
    public static <T> T unsafeLastElement(T @NotNull [] array) {
        if (array.length == 0) {
            return null;
        }
        return array[array.length - 1];
    }

    public static Object @NotNull [] toObjectArray(Object array) {
        return ArrsImpl.toObjectArray(array);
    }

    public static Number @NotNull [] numberOf(Number ... elements) {
        return elements;
    }

    public static boolean[] booleanOf(boolean ... elements) {
        return elements;
    }

    public static char[] charOf(char ... elements) {
        return elements;
    }

    @Contract(pure=true)
    public static int indexOf(char @NotNull [] array, char element) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(char @NotNull [] array, char element) {
        int maxSize;
        for (int i = maxSize = array.length - 1; i >= 0; --i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(char @NotNull [] array, char element) {
        return Arrs.indexOf(array, element) != -1;
    }

    @NotNull
    public static Optional<Character> lastElement(char @NotNull [] array) {
        if (array.length == 0) {
            return Optional.empty();
        }
        return Optional.of(Character.valueOf(array[array.length - 1]));
    }

    public static char unsafeLastElement(char @NotNull [] array) {
        if (array.length == 0) {
            throw new IllegalStateException("The array is empty");
        }
        return array[array.length - 1];
    }

    public static byte @NotNull [] byteOf(Number ... elements) {
        byte[] result = new byte[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            result[i] = elements[i].byteValue();
        }
        return result;
    }

    public static Number @NotNull [] toNumberOf(byte[] array) {
        return ArrsImpl.toNumberArray(array);
    }

    @Contract(pure=true)
    public static int indexOf(byte @NotNull [] array, byte element) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(byte @NotNull [] array, byte element) {
        int maxSize;
        for (int i = maxSize = array.length - 1; i >= 0; --i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(byte @NotNull [] array, byte element) {
        return Arrs.indexOf(array, element) != -1;
    }

    @NotNull
    public static Optional<Byte> lastElement(byte @NotNull [] array) {
        if (array.length == 0) {
            return Optional.empty();
        }
        return Optional.of(array[array.length - 1]);
    }

    public static byte unsafeLastElement(byte @NotNull [] array) {
        if (array.length == 0) {
            throw new IllegalStateException("The array is empty");
        }
        return array[array.length - 1];
    }

    public static short @NotNull [] shortOf(Number ... elements) {
        short[] result = new short[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            result[i] = elements[i].shortValue();
        }
        return result;
    }

    public static Number @NotNull [] toNumberOf(short[] array) {
        return ArrsImpl.toNumberArray(array);
    }

    @Contract(pure=true)
    public static int indexOf(short @NotNull [] array, short element) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(short @NotNull [] array, short element) {
        int maxSize;
        for (int i = maxSize = array.length - 1; i >= 0; --i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(short @NotNull [] array, short element) {
        return Arrs.indexOf(array, element) != -1;
    }

    @NotNull
    public static Optional<Short> lastElement(short @NotNull [] array) {
        if (array.length == 0) {
            return Optional.empty();
        }
        return Optional.of(array[array.length - 1]);
    }

    public static short unsafeLastElement(short @NotNull [] array) {
        if (array.length == 0) {
            throw new IllegalStateException("The array is empty");
        }
        return array[array.length - 1];
    }

    public static int[] intOf(int ... elements) {
        return elements;
    }

    public static Number @NotNull [] toNumberOf(int[] array) {
        return ArrsImpl.toNumberArray(array);
    }

    @Contract(pure=true)
    public static int indexOf(int @NotNull [] array, int element) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(int @NotNull [] array, int element) {
        int maxSize;
        for (int i = maxSize = array.length - 1; i >= 0; --i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(int @NotNull [] array, int element) {
        return Arrs.indexOf(array, element) != -1;
    }

    @NotNull
    public static Optional<Integer> lastElement(int @NotNull [] array) {
        if (array.length == 0) {
            return Optional.empty();
        }
        return Optional.of(array[array.length - 1]);
    }

    public static int unsafeLastElement(int @NotNull [] array) {
        if (array.length == 0) {
            throw new IllegalStateException("The array is empty");
        }
        return array[array.length - 1];
    }

    public static long[] longOf(long ... elements) {
        return elements;
    }

    public static Number @NotNull [] toNumberOf(long[] array) {
        return ArrsImpl.toNumberArray(array);
    }

    @Contract(pure=true)
    public static int indexOf(long @NotNull [] array, long element) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(long @NotNull [] array, long element) {
        int maxSize;
        for (int i = maxSize = array.length - 1; i >= 0; --i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(long @NotNull [] array, long element) {
        return Arrs.indexOf(array, element) != -1;
    }

    @NotNull
    public static Optional<Long> lastElement(long @NotNull [] array) {
        if (array.length == 0) {
            return Optional.empty();
        }
        return Optional.of(array[array.length - 1]);
    }

    public static long unsafeLastElement(long @NotNull [] array) {
        if (array.length == 0) {
            throw new IllegalStateException("The array is empty");
        }
        return array[array.length - 1];
    }

    public static float[] floatOf(float ... elements) {
        return elements;
    }

    public static Number @NotNull [] toNumberOf(float[] array) {
        return ArrsImpl.toNumberArray(array);
    }

    @Contract(pure=true)
    public static int indexOf(float @NotNull [] array, float element) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(float @NotNull [] array, float element) {
        int maxSize;
        for (int i = maxSize = array.length - 1; i >= 0; --i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(float @NotNull [] array, float element) {
        return Arrs.indexOf(array, element) != -1;
    }

    @NotNull
    public static Optional<Float> lastElement(float @NotNull [] array) {
        if (array.length == 0) {
            return Optional.empty();
        }
        return Optional.of(Float.valueOf(array[array.length - 1]));
    }

    public static float unsafeLastElement(float @NotNull [] array) {
        if (array.length == 0) {
            throw new IllegalStateException("The array is empty");
        }
        return array[array.length - 1];
    }

    public static double[] doubleOf(double ... elements) {
        return elements;
    }

    public static Number @NotNull [] toNumberOf(double[] array) {
        return ArrsImpl.toNumberArray(array);
    }

    @Contract(pure=true)
    public static int indexOf(double @NotNull [] array, double element) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(double @NotNull [] array, double element) {
        int maxSize;
        for (int i = maxSize = array.length - 1; i >= 0; --i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(double @NotNull [] array, double element) {
        return Arrs.indexOf(array, element) != -1;
    }

    @NotNull
    public static Optional<Double> lastElement(double @NotNull [] array) {
        if (array.length == 0) {
            return Optional.empty();
        }
        return Optional.of(array[array.length - 1]);
    }

    public static double unsafeLastElement(double @NotNull [] array) {
        if (array.length == 0) {
            throw new IllegalStateException("The array is empty");
        }
        return array[array.length - 1];
    }
}

