/*
 * Decompiled with CFR 0.152.
 */
package ushiosan.jvm_utilities.lang.collection;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import ushiosan.jvm_utilities.lang.collection.elements.Pair;

public final class Collections {
    private static final Pair[] EMPTY_PAIR = new Pair[0];

    private Collections() {
    }

    @SafeVarargs
    @Contract(pure=true)
    public static <T> @Unmodifiable List<T> listOf(T ... elements) {
        return List.of(elements);
    }

    public static <T> @Unmodifiable List<T> listOf(@NotNull Collection<T> base) {
        return List.copyOf(base);
    }

    public static <T> @Unmodifiable @NotNull List<T> listOf(@NotNull Iterator<T> iterator) {
        return java.util.Collections.unmodifiableList(Collections.mutableListOf(iterator));
    }

    @SafeVarargs
    @Contract(value="_ -> new")
    @NotNull
    public static <T> List<T> mutableListOf(T ... elements) {
        ArrayList<T> result = new ArrayList<T>(elements.length);
        for (T it : elements) {
            result.add(it);
        }
        return result;
    }

    @NotNull
    public static <T> List<T> mutableListOf(@NotNull Collection<T> base) {
        return new ArrayList<T>(base);
    }

    @NotNull
    public static <T> List<T> mutableListOf(@NotNull Iterator<T> iterator) {
        ArrayList base = new ArrayList();
        iterator.forEachRemaining(base::add);
        return base;
    }

    @SafeVarargs
    @NotNull
    public static <T> List<T> linkedListOf(T ... elements) {
        return new LinkedList<T>(Collections.listOf(elements));
    }

    @NotNull
    public static <T> List<T> linkedListOf(@NotNull Collection<T> base) {
        return new LinkedList<T>(base);
    }

    @SafeVarargs
    @NotNull
    public static <T> Stack<T> stackOf(T ... elements) {
        Stack<T> result = new Stack<T>();
        for (T it : elements) {
            result.add(it);
        }
        return result;
    }

    @NotNull
    public static <T> Stack<T> stackOf(@NotNull Collection<T> base) {
        Stack<T> result = new Stack<T>();
        result.addAll(base);
        return result;
    }

    @SafeVarargs
    @NotNull
    public static <T> Vector<T> vectorOf(T ... elements) {
        Vector<T> result = new Vector<T>(elements.length);
        for (T it : elements) {
            result.add(it);
        }
        return result;
    }

    @NotNull
    public static <T> Vector<T> vectorOf(@NotNull Collection<T> base) {
        Vector<T> result = new Vector<T>(base.size());
        result.addAll(base);
        return result;
    }

    @SafeVarargs
    public static <T> @Unmodifiable @NotNull Set<T> setOf(T ... elements) {
        return Set.of(elements);
    }

    public static <T> @Unmodifiable @NotNull Set<T> setOf(@NotNull Collection<T> base) {
        return Set.of(base.toArray());
    }

    @SafeVarargs
    @NotNull
    public static <T> Set<T> mutableSetOf(T ... elements) {
        HashSet<T> result = new HashSet<T>(elements.length);
        for (T it : elements) {
            result.add(it);
        }
        return result;
    }

    @NotNull
    public static <T> Set<T> mutableSetOf(@NotNull Collection<T> base) {
        HashSet<T> result = new HashSet<T>(base.size());
        result.addAll(base);
        return result;
    }

    @SafeVarargs
    @NotNull
    public static <T> Set<T> linkedSetOf(T ... elements) {
        LinkedHashSet<T> result = new LinkedHashSet<T>(elements.length);
        for (T it : elements) {
            result.add(it);
        }
        return result;
    }

    @NotNull
    public static <T> Set<T> linkedSetOf(@NotNull Collection<T> base) {
        LinkedHashSet<T> result = new LinkedHashSet<T>(base.size());
        result.addAll(base);
        return result;
    }

    @SafeVarargs
    @NotNull
    public static <T> Set<T> treeSetOf(@Nullable Comparator<T> comparator, T ... elements) {
        TreeSet<T> result = new TreeSet<T>(comparator);
        for (T it : elements) {
            result.add(it);
        }
        return result;
    }

    @SafeVarargs
    @NotNull
    public static <T> Set<T> treeSetOf(T ... elements) {
        return Collections.treeSetOf(null, elements);
    }

    @NotNull
    public static <T> Set<T> treeSetOf(@Nullable Comparator<T> comparator, @NotNull Collection<T> base) {
        TreeSet<T> result = new TreeSet<T>(comparator);
        result.addAll(base);
        return result;
    }

    @NotNull
    public static <T extends Enum<T>> Set<T> enumSetOf(@NotNull Class<T> cls) {
        return EnumSet.allOf(cls);
    }

    public static <K, V> @Unmodifiable @NotNull Map<K, V> mapOf() {
        return Collections.mapOf(EMPTY_PAIR);
    }

    @SafeVarargs
    public static <K, V> @Unmodifiable @NotNull Map<K, V> mapOf(Map.Entry<K, V> ... entries) {
        return java.util.Collections.unmodifiableMap(Collections.mutableMapOf(entries));
    }

    @SafeVarargs
    public static <K, V> @Unmodifiable @NotNull Map<K, V> mapOf(Pair<K, V> ... pairs) {
        return java.util.Collections.unmodifiableMap(Collections.mutableMapOf(pairs));
    }

    @NotNull
    public static <K, V> Map<K, V> mutableMapOf() {
        return Collections.mutableMapOf(EMPTY_PAIR);
    }

    @SafeVarargs
    @NotNull
    public static <K, V> Map<K, V> mutableMapOf(Map.Entry<K, V> ... entries) {
        HashMap<K, V> result = new HashMap<K, V>(entries.length);
        for (Map.Entry<K, V> it : entries) {
            result.put(it.getKey(), it.getValue());
        }
        return result;
    }

    @SafeVarargs
    @NotNull
    public static <K, V> Map<K, V> mutableMapOf(Pair<K, V> ... pairs) {
        HashMap result = new HashMap(pairs.length);
        for (Pair<K, V> it : pairs) {
            result.put(it.first, it.second);
        }
        return result;
    }

    @SafeVarargs
    @NotNull
    public static <K, V> Map<K, V> weakMapOf(Map.Entry<K, V> ... entries) {
        WeakHashMap<K, V> result = new WeakHashMap<K, V>(entries.length);
        for (Map.Entry<K, V> it : entries) {
            result.put(it.getKey(), it.getValue());
        }
        return result;
    }

    @SafeVarargs
    @NotNull
    public static <K, V> Map<K, V> weakMapOf(Pair<K, V> ... pairs) {
        WeakHashMap result = new WeakHashMap(pairs.length);
        for (Pair<K, V> it : pairs) {
            result.put(it.first, it.second);
        }
        return result;
    }

    @SafeVarargs
    @NotNull
    public static <K, V> Map<K, V> linkedMapOf(Map.Entry<K, V> ... entries) {
        LinkedHashMap<K, V> result = new LinkedHashMap<K, V>(entries.length);
        for (Map.Entry<K, V> it : entries) {
            result.put(it.getKey(), it.getValue());
        }
        return result;
    }

    @SafeVarargs
    @NotNull
    public static <K, V> Map<K, V> linkedMapOf(Pair<K, V> ... pairs) {
        LinkedHashMap result = new LinkedHashMap(pairs.length);
        for (Pair<K, V> it : pairs) {
            result.put(it.first, it.second);
        }
        return result;
    }

    public static <K, V> @Unmodifiable @NotNull Map.Entry<K, V> entryOf(K key, V value) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
    }

    public static <K, V> @NotNull Map.Entry<K, V> mutableEntryOf(K key, V value) {
        return new AbstractMap.SimpleEntry<K, V>(key, value);
    }
}

