/*
 * Decompiled with CFR 0.152.
 */
package ushiosan.jvm_utilities.lang.collection;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import ushiosan.jvm_utilities.lang.collection.Collections;
import ushiosan.jvm_utilities.lang.collection.elements.Pair;

public final class CollectionsSync {
    private CollectionsSync() {
    }

    @NotNull
    public static <T> Collection<T> collectionOf(@NotNull Collection<T> base) {
        return java.util.Collections.synchronizedCollection(base);
    }

    @SafeVarargs
    @NotNull
    public static <T> List<T> listOf(T ... elements) {
        return java.util.Collections.synchronizedList(List.of(elements));
    }

    @SafeVarargs
    @NotNull
    public static <T> Set<T> setOf(T ... elements) {
        return java.util.Collections.synchronizedSet(Set.of(elements));
    }

    @SafeVarargs
    @NotNull
    public static <K, V> Map<K, V> mapOf(Map.Entry<K, V> ... entries) {
        Map<K, V> base = Collections.mapOf(entries);
        return java.util.Collections.synchronizedMap(base);
    }

    @SafeVarargs
    @NotNull
    public static <K, V> Map<K, V> mapOf(Pair<K, V> ... pairs) {
        Map<K, V> base = Collections.mapOf(pairs);
        return java.util.Collections.synchronizedMap(base);
    }
}

