/*
 * Decompiled with CFR 0.152.
 */
package ushiosan.jvm_utilities.lang.collection.elements;

import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import ushiosan.jvm_utilities.lang.Obj;

public class Pair<T, K> {
    public final T first;
    public final K second;

    public Pair(T first, K second) {
        this.first = first;
        this.second = second;
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static <T, K> Pair<T, K> of(T first, K second) {
        return new Pair<T, K>(first, second);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <T, K> Pair<T, K> copyOf(@NotNull Map.Entry<T, K> entry) {
        return Pair.of(entry.getKey(), entry.getValue());
    }

    public static <T, K> Pair<T, K> @NotNull [] extractPairs(@NotNull Map<T, K> map) {
        int counter = 0;
        Pair[] result = new Pair[map.size()];
        for (Map.Entry<T, K> current : map.entrySet()) {
            result[counter++] = Pair.copyOf(current);
        }
        return result;
    }

    public String toString() {
        return "(" + Obj.toString(this.first) + ", " + Obj.toString(this.second) + ")";
    }
}

