/*
 * Decompiled with CFR 0.152.
 */
package ushiosan.jvm_utilities.lang.io;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import ushiosan.jvm_utilities.internal.io.IOImpl;
import ushiosan.jvm_utilities.lang.Obj;

public final class IO
extends IOImpl {
    public static final String[] EMPTY_EXTENSIONS = new String[0];
    public static final char EXTENSION_IDENTIFIER = '.';
    private static final String INVALID_FILE_TYPE = "The argument is not valid \"%s\" type. A \"%s\" given";

    private IO() {
    }

    @NotNull
    public static String getBaseName(@NotNull Path path) {
        String pathStr = path.getFileName().toString();
        if (Files.isDirectory(path, new LinkOption[0])) {
            return pathStr;
        }
        int extIndex = pathStr.indexOf(46);
        if (extIndex != -1) {
            pathStr = pathStr.substring(0, extIndex);
        }
        return pathStr;
    }

    @Contract(value="_ -> new")
    public static String @NotNull [] getAllExtensions(@NotNull Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format(INVALID_FILE_TYPE, "Regular File", "Directory"));
        }
        String baseName = IO.getBaseName(path);
        String pathStr = path.getFileName().toString();
        int extIndex = pathStr.indexOf(46);
        if (extIndex == -1) {
            return EMPTY_EXTENSIONS;
        }
        String pattern = "\\.";
        return (String[])Arrays.stream(pathStr.split(pattern)).filter(it -> !baseName.contentEquals((CharSequence)it)).toArray(String[]::new);
    }

    @NotNull
    public static Optional<String> getExtension(@NotNull Path path) {
        String[] extensions = IO.getAllExtensions(path);
        if (extensions.length == 0) {
            return Optional.empty();
        }
        int lastIndex = extensions.length - 1;
        return Optional.of(extensions[lastIndex]);
    }

    @NotNull
    public static String getExtensionUnsafe(@NotNull Path path) {
        return IO.getExtension(path).orElse("");
    }

    @NotNull
    public static Path resolveUserPath(String ... location) {
        return Path.of(System.getProperty("user.home"), location);
    }

    @NotNull
    public static Path getUserPath() {
        return IO.resolveUserPath(new String[0]);
    }

    @SafeVarargs
    @NotNull
    public static Stream<Path> walkDir(@NotNull Path location, boolean recursive, Predicate<Path> ... predicates) throws IOException {
        Stream<Path> walkObj = recursive ? Files.walk(location, new FileVisitOption[0]) : Files.walk(location, 1, new FileVisitOption[0]);
        return Obj.apply(walkObj, it -> {
            for (Predicate predicate : predicates) {
                it = it.filter(predicate);
            }
            return it;
        });
    }

    @SafeVarargs
    public static Path @NotNull [] walkDirArr(@NotNull Path location, boolean recursive, Predicate<Path> ... predicates) throws IOException {
        try (Stream<Path> walk = IO.walkDir(location, recursive, predicates);){
            Path[] pathArray = (Path[])walk.toArray(Path[]::new);
            return pathArray;
        }
    }

    @NotNull
    public static FileSystem getFilesystem(@NotNull URL url) throws IOException {
        return IO.getValidFilesystem(url);
    }

    @NotNull
    public static FileSystem getFilesystem(@NotNull URI uri) throws IOException {
        return IO.getValidFilesystem(uri);
    }

    @NotNull
    public static Path pathOf(@NotNull URL url) throws IOException {
        return IO.getValidPath(url);
    }

    @NotNull
    public static Path pathOf(@NotNull URI uri) throws IOException {
        return IO.getValidPath(uri);
    }
}

