/*
 * Decompiled with CFR 0.152.
 */
package ushiosan.jvm_utilities.lang.random;

import java.util.Random;
import org.jetbrains.annotations.NotNull;
import ushiosan.jvm_utilities.lang.Obj;
import ushiosan.jvm_utilities.lang.collection.Arrs;
import ushiosan.jvm_utilities.lang.random.TextType;

public final class Rand {
    private static Random sysRandom;
    private static final int DEFAULT_SIZE = 18;
    private static long randomSeed;

    private Rand() {
    }

    @NotNull
    public static Random getRandom(long seed) {
        long oldSeed = randomSeed;
        if (randomSeed == -1L || seed != randomSeed) {
            randomSeed = seed;
        }
        if (Obj.isNull(sysRandom)) {
            sysRandom = new Random(randomSeed);
        }
        if (seed != oldSeed) {
            sysRandom.setSeed(randomSeed);
        }
        return sysRandom;
    }

    @NotNull
    public static Random getRandom() {
        return Rand.getRandom(randomSeed == -1L ? System.currentTimeMillis() : randomSeed);
    }

    @NotNull
    public static String getRandomString(int size, @NotNull TextType type, char ... ignore) {
        return Rand.getRandom().ints(type.start, type.end).filter(n -> !(n > 57 && n < 65 || n > 90 && n < 97)).filter(n -> !Arrs.contains(ignore, (char)n)).limit(size).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    @NotNull
    public static String getRandomString(int size, char ... ignore) {
        return Rand.getRandomString(size, TextType.ALL_SYMBOLS, ignore);
    }

    @NotNull
    public static String getRandomString(char ... ignore) {
        return Rand.getRandomString(18, ignore);
    }

    public static int[] getRandomRange(int start, int end, long limit, boolean inclusive) {
        if (inclusive && end > Integer.MIN_VALUE && end < Integer.MAX_VALUE) {
            end = end < 0 ? end - 1 : end + 1;
        }
        return Rand.getRandom().ints(start, end).limit(limit).toArray();
    }

    public static int[] getRandomRange(int start, int end, long limit) {
        return Rand.getRandomRange(start, end, limit, true);
    }

    public static long[] getRandomRange(long start, long end, long limit, boolean inclusive) {
        if (inclusive && end > Long.MIN_VALUE && end < Long.MAX_VALUE) {
            end = end < 0L ? end - 1L : end + 1L;
        }
        return Rand.getRandom().longs(start, end).limit(limit).toArray();
    }

    public static long[] getRandomRange(long start, long end, long limit) {
        return Rand.getRandomRange(start, end, limit, true);
    }

    static {
        randomSeed = -1L;
    }
}

