/*
 * Decompiled with CFR 0.152.
 */
package ushiosan.jvm_utilities.system;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ushiosan.jvm_utilities.lang.Obj;
import ushiosan.jvm_utilities.lang.print.annotations.PrintOpts;

@PrintOpts(getterAccess=true, getterPrefix="^(is|name)")
public enum Arch {
    ARM("(arm)"),
    X64("(x64|amd64|sparc|ppc|aarch64)"),
    X86("(x86|i386)"),
    UNKNOWN(null);

    @Nullable
    private final Pattern pattern;

    private Arch(String regex) {
        this.pattern = regex != null ? Pattern.compile(regex) : null;
    }

    public static String getRawArch() {
        return System.getProperty("os.arch");
    }

    public static Arch getRunningArch() {
        Arch[] allValidArch;
        String nativeArch = Arch.getRawArch();
        for (Arch arch : allValidArch = (Arch[])Arrays.stream(Arch.values()).filter(Obj::isNotNull).toArray(Arch[]::new)) {
            Matcher matcher = arch.pattern.matcher(nativeArch);
            if (!matcher.find()) continue;
            return arch;
        }
        return UNKNOWN;
    }

    @NotNull
    public String toString() {
        return Obj.toInstanceString((Object)this);
    }
}

