/*
 * Decompiled with CFR 0.152.
 */
package ushiosan.jvm_utilities.system;

import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ushiosan.jvm_utilities.lang.Obj;
import ushiosan.jvm_utilities.lang.print.annotations.PrintOpts;

@PrintOpts(getterAccess=true, getterPrefix="^(is|name)")
public enum Platform {
    FREE_BSD("^(freebsd|free)"),
    LINUX("^(linux)"),
    MACOS("^(mac)"),
    SOLARIS("^(sunos|sun)"),
    WINDOWS("^(windows|win)"),
    UNKNOWN(null);

    @Nullable
    private final Pattern pattern;

    private Platform(String regex) {
        this.pattern = regex != null ? Pattern.compile(regex) : null;
    }

    public static Platform getRunningPlatform() {
        Platform[] allValidPlatforms;
        String nativeOs = System.getProperty("os.name").toLowerCase();
        for (Platform platform : allValidPlatforms = (Platform[])Arrays.stream(Platform.values()).filter(it -> it.pattern != null).toArray(Platform[]::new)) {
            Matcher matcher = platform.pattern.matcher(nativeOs);
            if (!matcher.find()) continue;
            return platform;
        }
        return UNKNOWN;
    }

    public boolean isUnix() {
        switch (this) {
            case FREE_BSD: 
            case LINUX: 
            case MACOS: 
            case SOLARIS: {
                return true;
            }
        }
        return false;
    }

    @Contract(pure=true)
    @NotNull
    public String getPlatformName() {
        if (this == UNKNOWN) {
            return "Unknown";
        }
        return System.getProperty("os.name");
    }

    public Optional<String> getVersion() {
        if (this == UNKNOWN) {
            return Optional.empty();
        }
        return Optional.of(System.getProperty("os.version"));
    }

    @NotNull
    public String toString() {
        return Obj.toInstanceString((Object)this);
    }
}

