package ushiosan.jvm_utilities.internal.collection;

/**
 * Interface used to handle constants for arrays.
 */
public interface IArrsConstants {
	
	/**
	 * number to represent not found operation in the arrays
	 */
	int INDEX_NOT_FOUND = -1;
	
	/**
	 * The null size of the arrays
	 */
	int EMPTY_SIZE = 0;
	
	/**
	 * An empty array of {@link Object} representing the absence of data
	 */
	Object[] OBJ_EMPTY = new Object[EMPTY_SIZE];
	
	/**
	 * An empty array of {@link Character} representing the absence of data
	 */
	char[] CHAR_EMPTY = new char[EMPTY_SIZE];
	
	/**
	 * An empty array of {@link Byte} representing the absence of data
	 */
	byte[] BYTE_EMPTY = new byte[EMPTY_SIZE];
	
	/**
	 * An empty array of {@link Short} representing the absence of data
	 */
	short[] SHORT_EMPTY = new short[EMPTY_SIZE];
	
	/**
	 * An empty array of {@link Integer} representing the absence of data
	 */
	int[] INT_EMPTY = new int[EMPTY_SIZE];
	
	/**
	 * An empty array of {@link Long} representing the absence of data
	 */
	long[] LONG_EMPTY = new long[EMPTY_SIZE];
	
	/**
	 * An empty array of {@link Float} representing the absence of data
	 */
	float[] FLOAT_EMPTY = new float[EMPTY_SIZE];
	
	/**
	 * An empty array of {@link Double} representing the absence of data
	 */
	double[] DOUBLE_EMPTY = new double[EMPTY_SIZE];
	
}
