/*
 * Decompiled with CFR 0.152.
 */
package com.github.vanroy.springdata.jest.facet;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.FacetedPage;
import org.springframework.data.elasticsearch.core.facet.FacetResult;

@Deprecated
public abstract class FacetedPageImpl<T>
extends PageImpl<T>
implements FacetedPage<T> {
    private List<FacetResult> facets;
    private Map<String, FacetResult> mapOfFacets = new HashMap<String, FacetResult>();

    public FacetedPageImpl(List<T> content) {
        super(content);
    }

    public FacetedPageImpl(List<T> content, Pageable pageable, long total) {
        super(content, pageable, total);
    }

    public FacetedPageImpl(List<T> content, Pageable pageable, long total, List<FacetResult> facets) {
        super(content, pageable, total);
        this.facets = facets;
        if (Objects.nonNull(facets)) {
            this.mapOfFacets = facets.stream().collect(Collectors.toMap(FacetResult::getName, Function.identity()));
        }
    }

    public boolean hasFacets() {
        return this.facets != null && !this.facets.isEmpty();
    }

    public List<FacetResult> getFacets() {
        return this.facets;
    }

    public FacetResult getFacet(String name) {
        return this.mapOfFacets.get(name);
    }

    private void addFacet(FacetResult facetResult) {
        this.facets.add(facetResult);
        this.mapOfFacets.put(facetResult.getName(), facetResult);
    }
}

